var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
var __rest = (this && this.__rest) || function (s, e) {
    var t = {};
    for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p) && e.indexOf(p) < 0)
        t[p] = s[p];
    if (s != null && typeof Object.getOwnPropertySymbols === "function")
        for (var i = 0, p = Object.getOwnPropertySymbols(s); i < p.length; i++) {
            if (e.indexOf(p[i]) < 0 && Object.prototype.propertyIsEnumerable.call(s, p[i]))
                t[p[i]] = s[p[i]];
        }
    return t;
};
var __spreadArray = (this && this.__spreadArray) || function (to, from, pack) {
    if (pack || arguments.length === 2) for (var i = 0, l = from.length, ar; i < l; i++) {
        if (ar || !(i in from)) {
            if (!ar) ar = Array.prototype.slice.call(from, 0, i);
            ar[i] = from[i];
        }
    }
    return to.concat(ar || Array.prototype.slice.call(from));
};
import * as React from 'react';
import { Children, isValidElement, } from 'react';
import { Form } from 'ra-core';
import get from 'lodash/get';
import { TabbedFormView } from './TabbedFormView';
import { useFormRootPath } from './useFormRootPath';
import { FormTab } from './FormTab';
/**
 * Form layout where inputs are divided by tab, one input per line.
 *
 * Pass <TabbedForm.Tab> components as children.
 *
 * @example
 *
 * import * as React from "react";
 * import {
 *     Edit,
 *     TabbedForm,
 *     Datagrid,
 *     TextField,
 *     DateField,
 *     TextInput,
 *     ReferenceManyField,
 *     NumberInput,
 *     DateInput,
 *     BooleanInput,
 *     EditButton
 * } from 'react-admin';
 *
 * export const PostEdit = () => (
 *     <Edit>
 *         <TabbedForm>
 *             <TabbedForm.Tab label="summary">
 *                 <TextInput disabled label="Id" source="id" />
 *                 <TextInput source="title" validate={required()} />
 *                 <TextInput multiline source="teaser" validate={required()} />
 *             </TabbedForm.Tab>
 *             <TabbedForm.Tab label="body">
 *                 <RichTextInput source="body" validate={required()} label={false} />
 *             </TabbedForm.Tab>
 *             <TabbedForm.Tab label="Miscellaneous">
 *                 <TextInput label="Password (if protected post)" source="password" type="password" />
 *                 <DateInput label="Publication date" source="published_at" />
 *                 <NumberInput source="average_note" validate={[ number(), minValue(0) ]} />
 *                 <BooleanInput label="Allow comments?" source="commentable" defaultValue />
 *                 <TextInput disabled label="Nb views" source="views" />
 *             </TabbedForm.Tab>
 *             <TabbedForm.Tab label="comments">
 *                 <ReferenceManyField reference="comments" target="post_id" label={false}>
 *                     <Datagrid>
 *                         <TextField source="body" />
 *                         <DateField source="created_at" />
 *                         <EditButton />
 *                     </Datagrid>
 *                 </ReferenceManyField>
 *             </TabbedForm.Tab>
 *         </TabbedForm>
 *     </Edit>
 * );
 *
 * @typedef {Object} Props the props you can use (other props are injected by Create or Edit)
 * @prop {ReactElement[]} FormTab elements
 * @prop {Object} defaultValues
 * @prop {Function} validate
 * @prop {ReactElement} toolbar The element displayed at the bottom of the form, containing the SaveButton
 *
 * @param {Props} props
 */
export var TabbedForm = function (props) {
    var formRootPathname = useFormRootPath();
    return (React.createElement(Form, __assign({ formRootPathname: formRootPathname }, props),
        React.createElement(TabbedFormView, __assign({ formRootPathname: formRootPathname }, sanitizeRestProps(props)))));
};
TabbedForm.Tab = FormTab;
/* eslint-disable @typescript-eslint/no-unused-vars */
var sanitizeRestProps = function (_a) {
    var criteriaMode = _a.criteriaMode, defaultValues = _a.defaultValues, delayError = _a.delayError, formRootPathname = _a.formRootPathname, mode = _a.mode, noValidate = _a.noValidate, onSubmit = _a.onSubmit, record = _a.record, resetOptions = _a.resetOptions, resolver = _a.resolver, reValidateMode = _a.reValidateMode, sanitizeEmptyValues = _a.sanitizeEmptyValues, shouldFocusError = _a.shouldFocusError, shouldUnregister = _a.shouldUnregister, shouldUseNativeValidation = _a.shouldUseNativeValidation, validate = _a.validate, warnWhenUnsavedChanges = _a.warnWhenUnsavedChanges, rest = __rest(_a, ["criteriaMode", "defaultValues", "delayError", "formRootPathname", "mode", "noValidate", "onSubmit", "record", "resetOptions", "resolver", "reValidateMode", "sanitizeEmptyValues", "shouldFocusError", "shouldUnregister", "shouldUseNativeValidation", "validate", "warnWhenUnsavedChanges"]);
    return rest;
};
export var findTabsWithErrors = function (children, errors) {
    console.warn('Deprecated. FormTab now wrap their content inside a FormGroupContextProvider. If you implemented custom forms with tabs, please use the FormGroupContextProvider. See https://marmelab.com/react-admin/EditTutorial.html#grouping-inputs');
    return Children.toArray(children).reduce(function (acc, child) {
        if (!isValidElement(child)) {
            return acc;
        }
        var inputs = Children.toArray(child.props.children);
        if (inputs.some(function (input) {
            return isValidElement(input) && get(errors, input.props.source);
        })) {
            return __spreadArray(__spreadArray([], acc, true), [child.props.label], false);
        }
        return acc;
    }, []);
};
//# sourceMappingURL=TabbedForm.js.map