var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
var __rest = (this && this.__rest) || function (s, e) {
    var t = {};
    for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p) && e.indexOf(p) < 0)
        t[p] = s[p];
    if (s != null && typeof Object.getOwnPropertySymbols === "function")
        for (var i = 0, p = Object.getOwnPropertySymbols(s); i < p.length; i++) {
            if (e.indexOf(p[i]) < 0 && Object.prototype.propertyIsEnumerable.call(s, p[i]))
                t[p[i]] = s[p[i]];
        }
    return t;
};
import * as React from 'react';
import { styled } from '@mui/material/styles';
import { Children } from 'react';
import { Toolbar as MuiToolbar, useMediaQuery, } from '@mui/material';
import clsx from 'clsx';
import { SaveButton, DeleteButton } from '../button';
/**
 * The Toolbar displayed at the bottom of forms.
 *
 * @example Always enable the <SaveButton />
 *
 * import * as React from 'react';
 * import {
 *     Create,
 *     DateInput,
 *     TextInput,
 *     SimpleForm,
 *     Toolbar,
 *     SaveButton,
 *     required,
 * } from 'react-admin';
 *
 * const now = new Date();
 * const defaultSort = { field: 'title', order: 'ASC' };
 *
 * const MyToolbar = props => (
 *     <Toolbar {...props} >
 *         <SaveButton alwaysEnable />
 *     </Toolbar>
 * );
 *
 * const CommentCreate = () => (
 *     <Create>
 *         <SimpleForm redirect={false} toolbar={<MyToolbar />}>
 *             <TextInput
 *                 source="author.name"
 *                 fullWidth
 *             />
 *             <DateInput source="created_at" defaultValue={now} />
 *             <TextInput source="body" fullWidth={true} multiline={true} />
 *         </SimpleForm>
 *     </Create>
 * );
 *
 * @typedef {Object} Props the props you can use (other props are injected by the <SimpleForm>)
 * @prop {ReactElement[]} children Customize the buttons you want to display in the <Toolbar>.
 *
 */
export var Toolbar = function (props) {
    var _a;
    var children = props.children, className = props.className, resource = props.resource, rest = __rest(props, ["children", "className", "resource"]);
    var isXs = useMediaQuery(function (theme) { return theme.breakpoints.down('sm'); });
    return (React.createElement(StyledToolbar, __assign({ className: clsx((_a = {},
            _a[ToolbarClasses.mobileToolbar] = isXs,
            _a[ToolbarClasses.desktopToolbar] = !isXs,
            _a), className), role: "toolbar" }, rest), Children.count(children) === 0 ? (React.createElement("div", { className: ToolbarClasses.defaultToolbar },
        React.createElement(SaveButton, null),
        React.createElement(DeleteButton, { resource: resource }))) : (children)));
};
var PREFIX = 'RaToolbar';
export var ToolbarClasses = {
    desktopToolbar: "".concat(PREFIX, "-desktopToolbar"),
    mobileToolbar: "".concat(PREFIX, "-mobileToolbar"),
    defaultToolbar: "".concat(PREFIX, "-defaultToolbar"),
};
var StyledToolbar = styled(MuiToolbar, {
    name: PREFIX,
    overridesResolver: function (props, styles) { return styles.root; },
})(function (_a) {
    var _b;
    var theme = _a.theme;
    return (_b = {
            backgroundColor: theme.palette.mode === 'light'
                ? theme.palette.grey[100]
                : theme.palette.grey[900]
        },
        _b["&.".concat(ToolbarClasses.desktopToolbar)] = {},
        _b["&.".concat(ToolbarClasses.mobileToolbar)] = {
            position: 'fixed',
            bottom: 0,
            left: 0,
            right: 0,
            padding: '16px',
            width: '100%',
            boxSizing: 'border-box',
            flexShrink: 0,
            zIndex: 2,
        },
        _b["& .".concat(ToolbarClasses.defaultToolbar)] = {
            flex: 1,
            display: 'flex',
            justifyContent: 'space-between',
        },
        _b);
});
//# sourceMappingURL=Toolbar.js.map