var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
var __rest = (this && this.__rest) || function (s, e) {
    var t = {};
    for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p) && e.indexOf(p) < 0)
        t[p] = s[p];
    if (s != null && typeof Object.getOwnPropertySymbols === "function")
        for (var i = 0, p = Object.getOwnPropertySymbols(s); i < p.length; i++) {
            if (e.indexOf(p[i]) < 0 && Object.prototype.propertyIsEnumerable.call(s, p[i]))
                t[p[i]] = s[p[i]];
        }
    return t;
};
import * as React from 'react';
import CloseIcon from '@mui/icons-material/RemoveCircleOutline';
import clsx from 'clsx';
import { IconButtonWithTooltip } from '../../button';
import { useSimpleFormIteratorItem } from './useSimpleFormIteratorItem';
import { useSimpleFormIterator } from './useSimpleFormIterator';
export var RemoveItemButton = function (props) {
    var _a = useSimpleFormIteratorItem(), remove = _a.remove, index = _a.index;
    var source = useSimpleFormIterator().source;
    var className = props.className, rest = __rest(props, ["className"]);
    return (React.createElement(IconButtonWithTooltip, __assign({ label: "ra.action.remove", size: "small", onClick: function () { return remove(); }, color: "warning", className: clsx("button-remove button-remove-".concat(source, "-").concat(index), className) }, rest),
        React.createElement(CloseIcon, { fontSize: "small" })));
};
//# sourceMappingURL=RemoveItemButton.js.map