var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
var __rest = (this && this.__rest) || function (s, e) {
    var t = {};
    for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p) && e.indexOf(p) < 0)
        t[p] = s[p];
    if (s != null && typeof Object.getOwnPropertySymbols === "function")
        for (var i = 0, p = Object.getOwnPropertySymbols(s); i < p.length; i++) {
            if (e.indexOf(p[i]) < 0 && Object.prototype.propertyIsEnumerable.call(s, p[i]))
                t[p[i]] = s[p[i]];
        }
    return t;
};
var __spreadArray = (this && this.__spreadArray) || function (to, from, pack) {
    if (pack || arguments.length === 2) for (var i = 0, l = from.length, ar; i < l; i++) {
        if (ar || !(i in from)) {
            if (!ar) ar = Array.prototype.slice.call(from, 0, i);
            ar[i] = from[i];
        }
    }
    return to.concat(ar || Array.prototype.slice.call(from));
};
import * as React from 'react';
import { styled } from '@mui/material/styles';
import clsx from 'clsx';
import { useCallback } from 'react';
import get from 'lodash/get';
import FormLabel from '@mui/material/FormLabel';
import FormControl from '@mui/material/FormControl';
import FormGroup from '@mui/material/FormGroup';
import FormHelperText from '@mui/material/FormHelperText';
import { FieldTitle, useInput, useChoicesContext, useGetRecordRepresentation, } from 'ra-core';
import { sanitizeInputRestProps } from './sanitizeInputRestProps';
import { CheckboxGroupInputItem } from './CheckboxGroupInputItem';
import { InputHelperText } from './InputHelperText';
import { Labeled } from '../Labeled';
import { LinearProgress } from '../layout';
/**
 * An Input component for a checkbox group, using an array of objects for the options
 *
 * Pass possible options as an array of objects in the 'choices' attribute.
 *
 * The expected input must be an array of identifiers (e.g. [12, 31]) which correspond to
 * the 'optionValue' of 'choices' attribute objects.
 *
 * By default, the options are built from:
 *  - the 'id' property as the option value,
 *  - the 'name' property as the option text
 * @example
 * const choices = [
 *     { id: 12, name: 'Ray Hakt' },
 *     { id: 31, name: 'Ann Gullar' },
 *     { id: 42, name: 'Sean Phonee' },
 * ];
 * <CheckboxGroupInput source="recipients" choices={choices} />
 *
 * You can also customize the properties to use for the option name and value,
 * thanks to the 'optionText' and 'optionValue' attributes.
 * @example
 * const choices = [
 *    { _id: 123, full_name: 'Leo Tolstoi' },
 *    { _id: 456, full_name: 'Jane Austen' },
 * ];
 * <CheckboxGroupInput source="recipients" choices={choices} optionText="full_name" optionValue="_id" />
 *
 * `optionText` also accepts a function, so you can shape the option text at will:
 * @example
 * const choices = [
 *    { id: 123, first_name: 'Leo', last_name: 'Tolstoi' },
 *    { id: 456, first_name: 'Jane', last_name: 'Austen' },
 * ];
 * const optionRenderer = choice => `${choice.first_name} ${choice.last_name}`;
 * <CheckboxGroupInput source="recipients" choices={choices} optionText={optionRenderer} />
 *
 * `optionText` also accepts a React Element, that can access
 * the related choice through the `useRecordContext` hook. You can use Field components there.
 * @example
 * const choices = [
 *    { id: 123, first_name: 'Leo', last_name: 'Tolstoi' },
 *    { id: 456, first_name: 'Jane', last_name: 'Austen' },
 * ];
 * const FullNameField = () => {
 *     const record = useRecordContext();
 *     return <span>{record.first_name} {record.last_name}</span>;
 * };
 *
 * <CheckboxGroupInput source="recipients" choices={choices} optionText={<FullNameField />}/>
 *
 * The choices are translated by default, so you can use translation identifiers as choices:
 * @example
 * const choices = [
 *    { id: 'programming', name: 'myroot.category.programming' },
 *    { id: 'lifestyle', name: 'myroot.category.lifestyle' },
 *    { id: 'photography', name: 'myroot.category.photography' },
 * ];
 *
 * However, in some cases (e.g. inside a `<ReferenceArrayInput>`), you may not want
 * the choice to be translated. In that case, set the `translateChoice` prop to false.
 * @example
 * <CheckboxGroupInput source="tags" choices={choices} translateChoice={false}/>
 *
 * The object passed as `options` props is passed to the Material UI <Checkbox> components
 */
export var CheckboxGroupInput = function (props) {
    var choicesProp = props.choices, className = props.className, classesOverride = props.classes, format = props.format, helperText = props.helperText, label = props.label, labelPlacement = props.labelPlacement, isLoadingProp = props.isLoading, isPendingProp = props.isPending, isFetchingProp = props.isFetching, _a = props.margin, margin = _a === void 0 ? 'dense' : _a, onBlur = props.onBlur, onChange = props.onChange, options = props.options, optionText = props.optionText, _b = props.optionValue, optionValue = _b === void 0 ? 'id' : _b, parse = props.parse, resourceProp = props.resource, _c = props.row, row = _c === void 0 ? true : _c, sourceProp = props.source, translateChoice = props.translateChoice, validate = props.validate, disabled = props.disabled, readOnly = props.readOnly, rest = __rest(props, ["choices", "className", "classes", "format", "helperText", "label", "labelPlacement", "isLoading", "isPending", "isFetching", "margin", "onBlur", "onChange", "options", "optionText", "optionValue", "parse", "resource", "row", "source", "translateChoice", "validate", "disabled", "readOnly"]);
    var _d = useChoicesContext({
        choices: choicesProp,
        isFetching: isFetchingProp,
        isLoading: isLoadingProp,
        isPending: isPendingProp,
        resource: resourceProp,
        source: sourceProp,
    }), allChoices = _d.allChoices, isPending = _d.isPending, fetchError = _d.error, resource = _d.resource, source = _d.source, isFromReference = _d.isFromReference;
    if (source === undefined) {
        throw new Error("If you're not wrapping the CheckboxGroupInput inside a ReferenceArrayInput, you must provide the source prop");
    }
    if (!isPending && !fetchError && allChoices === undefined) {
        throw new Error("If you're not wrapping the CheckboxGroupInput inside a ReferenceArrayInput, you must provide the choices prop");
    }
    var _e = useInput(__assign({ format: format, parse: parse, resource: resource, source: source, validate: validate, onChange: onChange, onBlur: onBlur, disabled: disabled, readOnly: readOnly }, rest)), _f = _e.field, formOnChange = _f.onChange, formOnBlur = _f.onBlur, value = _f.value, ref = _f.ref, _g = _e.fieldState, error = _g.error, invalid = _g.invalid, id = _e.id, isRequired = _e.isRequired;
    var getRecordRepresentation = useGetRecordRepresentation(resource);
    var handleCheck = useCallback(function (event, isChecked) {
        var newValue;
        if (allChoices &&
            allChoices.every(function (item) { return typeof get(item, optionValue) === 'number'; })) {
            try {
                // try to convert string value to number, e.g. '123'
                newValue = JSON.parse(event.target.value);
            }
            catch (e) {
                // impossible to convert value, e.g. 'abc'
                newValue = event.target.value;
            }
        }
        else {
            newValue = event.target.value;
        }
        if (isChecked) {
            formOnChange(__spreadArray(__spreadArray([], (value || []), true), [newValue], false));
        }
        else {
            formOnChange(value.filter(function (v) { return v != newValue; })); // eslint-disable-line eqeqeq
        }
        formOnBlur(); // Ensure field is flagged as touched
    }, [allChoices, formOnChange, formOnBlur, optionValue, value]);
    if (isPending) {
        return (React.createElement(Labeled, __assign({ id: id, label: label, source: source, resource: resource, className: clsx('ra-input', "ra-input-".concat(source), className), isRequired: isRequired }, rest),
            React.createElement(LinearProgress, null)));
    }
    var renderHelperText = !!fetchError || helperText !== false || invalid;
    return (React.createElement(StyledFormControl, __assign({ component: "fieldset", margin: margin, error: fetchError || invalid, className: clsx('ra-input', "ra-input-".concat(source), className) }, sanitizeRestProps(rest)),
        React.createElement(FormLabel, { component: "legend", className: CheckboxGroupInputClasses.label },
            React.createElement(FieldTitle, { label: label, source: source, resource: resource, isRequired: isRequired })),
        React.createElement(FormGroup, { row: row }, allChoices === null || allChoices === void 0 ? void 0 : allChoices.map(function (choice, index) { return (React.createElement(CheckboxGroupInputItem, __assign({ key: get(choice, optionValue), choice: choice, id: id, onChange: handleCheck, options: options, optionText: optionText !== null && optionText !== void 0 ? optionText : (isFromReference ? getRecordRepresentation : 'name'), optionValue: optionValue, translateChoice: translateChoice !== null && translateChoice !== void 0 ? translateChoice : !isFromReference, value: value, labelPlacement: labelPlacement, inputRef: index === 0 ? ref : undefined, disabled: disabled || readOnly, readOnly: readOnly }, sanitizeRestProps(rest)))); })),
        renderHelperText ? (React.createElement(FormHelperText, { error: !!fetchError || !!error, className: CheckboxGroupInputClasses.helperText },
            React.createElement(InputHelperText, { error: (error === null || error === void 0 ? void 0 : error.message) || (fetchError === null || fetchError === void 0 ? void 0 : fetchError.message), helperText: helperText }))) : null));
};
var sanitizeRestProps = function (_a) {
    var refetch = _a.refetch, setFilter = _a.setFilter, setPagination = _a.setPagination, setSort = _a.setSort, loaded = _a.loaded, touched = _a.touched, rest = __rest(_a, ["refetch", "setFilter", "setPagination", "setSort", "loaded", "touched"]);
    return sanitizeInputRestProps(rest);
};
var PREFIX = 'RaCheckboxGroupInput';
export var CheckboxGroupInputClasses = {
    label: "".concat(PREFIX, "-label"),
    helperText: "".concat(PREFIX, "-helperText"),
};
var StyledFormControl = styled(FormControl, {
    name: PREFIX,
    overridesResolver: function (props, styles) { return styles.root; },
})(function (_a) {
    var _b;
    var theme = _a.theme;
    return (_b = {},
        _b["& .".concat(CheckboxGroupInputClasses.label)] = {
            transform: 'translate(0, 4px) scale(0.75)',
            transformOrigin: "top ".concat(theme.direction === 'ltr' ? 'left' : 'right'),
        },
        _b["& .".concat(CheckboxGroupInputClasses.helperText)] = {
            marginLeft: 0,
            marginRight: 0,
        },
        _b);
});
//# sourceMappingURL=CheckboxGroupInput.js.map