var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
var __rest = (this && this.__rest) || function (s, e) {
    var t = {};
    for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p) && e.indexOf(p) < 0)
        t[p] = s[p];
    if (s != null && typeof Object.getOwnPropertySymbols === "function")
        for (var i = 0, p = Object.getOwnPropertySymbols(s); i < p.length; i++) {
            if (e.indexOf(p[i]) < 0 && Object.prototype.propertyIsEnumerable.call(s, p[i]))
                t[p[i]] = s[p[i]];
        }
    return t;
};
import * as React from 'react';
import clsx from 'clsx';
import TextField from '@mui/material/TextField';
import { useInput, FieldTitle, mergeRefs } from 'ra-core';
import { sanitizeInputRestProps } from './sanitizeInputRestProps';
import { InputHelperText } from './InputHelperText';
/**
 * Form input to edit a Date string value in the "YYYY-MM-DD" format (e.g. '2021-06-23').
 *
 * Renders a date picker (the exact UI depends on the browser).
 *
 * @example
 * import { Edit, SimpleForm, DateInput } from 'react-admin';
 *
 * const PostEdit = () => (
 *     <Edit>
 *         <SimpleForm>
 *             <DateInput source="published_at" />
 *         </SimpleForm>
 *     </Edit>
 * );
 *
 * @example
 * // If the initial value is a Date object, DateInput converts it to a string
 * // but you must pass a custom parse method to convert the form value
 * // (which is always a date string) back to a Date object.
 * <DateInput source="published_at" parse={val => new Date(val)} />
 */
export var DateInput = function (_a) {
    var className = _a.className, defaultValue = _a.defaultValue, _b = _a.format, format = _b === void 0 ? getStringFromDate : _b, label = _a.label, source = _a.source, resource = _a.resource, helperText = _a.helperText, margin = _a.margin, onBlur = _a.onBlur, onChange = _a.onChange, onFocus = _a.onFocus, parse = _a.parse, validate = _a.validate, variant = _a.variant, disabled = _a.disabled, readOnly = _a.readOnly, rest = __rest(_a, ["className", "defaultValue", "format", "label", "source", "resource", "helperText", "margin", "onBlur", "onChange", "onFocus", "parse", "validate", "variant", "disabled", "readOnly"]);
    var _c = useInput(__assign({ defaultValue: defaultValue, onBlur: onBlur, resource: resource, source: source, validate: validate, disabled: disabled, readOnly: readOnly }, rest)), field = _c.field, fieldState = _c.fieldState, id = _c.id, isRequired = _c.isRequired;
    var _d = React.useState(1), renderCount = _d[0], setRenderCount = _d[1];
    var valueChangedFromInput = React.useRef(false);
    var localInputRef = React.useRef();
    var initialDefaultValueRef = React.useRef(field.value);
    React.useEffect(function () {
        var initialDateValue = new Date(initialDefaultValueRef.current).getTime() || null;
        var fieldDateValue = new Date(field.value).getTime() || null;
        if (initialDateValue !== fieldDateValue &&
            !valueChangedFromInput.current) {
            setRenderCount(function (r) { return r + 1; });
            parse
                ? field.onChange(parse(field.value))
                : field.onChange(field.value);
            initialDefaultValueRef.current = field.value;
            valueChangedFromInput.current = false;
        }
    }, [setRenderCount, parse, field]);
    var onBlurFromField = field.onBlur;
    var hasFocus = React.useRef(false);
    // update the input text when the user types in the input
    var handleChange = function (event) {
        if (onChange) {
            onChange(event);
        }
        if (typeof event.target === 'undefined' ||
            typeof event.target.value === 'undefined') {
            return;
        }
        var target = event.target;
        var newValue = target.valueAsDate !== undefined &&
            target.valueAsDate !== null &&
            !isNaN(new Date(target.valueAsDate).getTime())
            ? parse
                ? parse(target.valueAsDate)
                : getStringFromDate(target.valueAsDate)
            : parse
                ? parse(target.value)
                : getStringFromDate(target.value);
        // Some browsers will return null for an invalid date so we only change react-hook-form value if it's not null
        // The input reset is handled in the onBlur event handler
        if (newValue !== '' && newValue != null) {
            field.onChange(newValue);
            valueChangedFromInput.current = true;
        }
    };
    var handleFocus = function (event) {
        if (onFocus) {
            onFocus(event);
        }
        hasFocus.current = true;
    };
    var handleBlur = function () {
        hasFocus.current = false;
        if (!localInputRef.current) {
            return;
        }
        // To ensure users can clear the input, we check its value on blur
        // and submit it to react-hook-form
        var newValue = localInputRef.current.valueAsDate !== undefined &&
            localInputRef.current.valueAsDate !== null &&
            !isNaN(new Date(localInputRef.current.valueAsDate).getTime())
            ? parse
                ? parse(localInputRef.current.valueAsDate)
                : getStringFromDate(localInputRef.current.valueAsDate)
            : parse
                ? parse(localInputRef.current.value)
                : getStringFromDate(localInputRef.current.value);
        if (newValue !== field.value) {
            field.onChange(newValue !== null && newValue !== void 0 ? newValue : '');
        }
        if (onBlurFromField) {
            onBlurFromField();
        }
    };
    var error = fieldState.error, invalid = fieldState.invalid;
    var renderHelperText = helperText !== false || invalid;
    var ref = field.ref, name = field.name;
    var inputRef = mergeRefs([ref, localInputRef]);
    return (React.createElement(TextField, __assign({ id: id, name: name, inputRef: inputRef, defaultValue: format(initialDefaultValueRef.current), key: renderCount, type: "date", onChange: handleChange, onFocus: handleFocus, onBlur: handleBlur, className: clsx('ra-input', "ra-input-".concat(source), className), size: "small", variant: variant, margin: margin, error: invalid, disabled: disabled || readOnly, readOnly: readOnly, helperText: renderHelperText ? (React.createElement(InputHelperText, { error: error === null || error === void 0 ? void 0 : error.message, helperText: helperText })) : null, label: React.createElement(FieldTitle, { label: label, source: source, resource: resource, isRequired: isRequired }), InputLabelProps: defaultInputLabelProps }, sanitizeInputRestProps(rest))));
};
/**
 * Convert Date object to String
 *
 * @param {Date} value value to convert
 * @returns {String} A standardized date (yyyy-MM-dd), to be passed to an <input type="date" />
 */
var convertDateToString = function (value) {
    if (!(value instanceof Date) || isNaN(value.getDate()))
        return '';
    var pad = '00';
    var yyyy = value.getFullYear().toString();
    var MM = (value.getMonth() + 1).toString();
    var dd = value.getDate().toString();
    return "".concat(yyyy, "-").concat((pad + MM).slice(-2), "-").concat((pad + dd).slice(-2));
};
var dateRegex = /^\d{4}-\d{2}-\d{2}$/;
var defaultInputLabelProps = { shrink: true };
var getStringFromDate = function (value) {
    // null, undefined and empty string values should not go through dateFormatter
    // otherwise, it returns undefined and will make the input an uncontrolled one.
    if (value == null || value === '') {
        return null;
    }
    if (value instanceof Date) {
        return convertDateToString(value);
    }
    // valid dates should not be converted
    if (dateRegex.test(value)) {
        return value;
    }
    return convertDateToString(new Date(value));
};
//# sourceMappingURL=DateInput.js.map