var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
var __rest = (this && this.__rest) || function (s, e) {
    var t = {};
    for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p) && e.indexOf(p) < 0)
        t[p] = s[p];
    if (s != null && typeof Object.getOwnPropertySymbols === "function")
        for (var i = 0, p = Object.getOwnPropertySymbols(s); i < p.length; i++) {
            if (e.indexOf(p[i]) < 0 && Object.prototype.propertyIsEnumerable.call(s, p[i]))
                t[p[i]] = s[p[i]];
        }
    return t;
};
import * as React from 'react';
import clsx from 'clsx';
import TextField from '@mui/material/TextField';
import { useInput, FieldTitle, mergeRefs } from 'ra-core';
import { sanitizeInputRestProps } from './sanitizeInputRestProps';
import { InputHelperText } from './InputHelperText';
/**
 * Converts a datetime string without timezone to a date object
 * with timezone, using the browser timezone.
 *
 * @param {string} value Date string, formatted as yyyy-MM-ddThh:mm
 * @return {Date}
 */
var parseDateTime = function (value) {
    return value ? new Date(value) : value === '' ? null : value;
};
/**
 * Input component for entering a date and a time with timezone, using the browser locale
 */
export var DateTimeInput = function (_a) {
    var className = _a.className, defaultValue = _a.defaultValue, _b = _a.format, format = _b === void 0 ? formatDateTime : _b, label = _a.label, helperText = _a.helperText, margin = _a.margin, onBlur = _a.onBlur, onChange = _a.onChange, onFocus = _a.onFocus, source = _a.source, resource = _a.resource, _c = _a.parse, parse = _c === void 0 ? parseDateTime : _c, validate = _a.validate, variant = _a.variant, disabled = _a.disabled, readOnly = _a.readOnly, rest = __rest(_a, ["className", "defaultValue", "format", "label", "helperText", "margin", "onBlur", "onChange", "onFocus", "source", "resource", "parse", "validate", "variant", "disabled", "readOnly"]);
    var _d = useInput(__assign({ defaultValue: defaultValue, onBlur: onBlur, resource: resource, source: source, validate: validate, disabled: disabled, readOnly: readOnly }, rest)), field = _d.field, fieldState = _d.fieldState, id = _d.id, isRequired = _d.isRequired;
    var _e = React.useState(1), renderCount = _e[0], setRenderCount = _e[1];
    var valueChangedFromInput = React.useRef(false);
    var localInputRef = React.useRef();
    var initialDefaultValueRef = React.useRef(field.value);
    React.useEffect(function () {
        var initialDateValue = new Date(initialDefaultValueRef.current).getTime() || null;
        var fieldDateValue = new Date(field.value).getTime() || null;
        if (initialDateValue !== fieldDateValue &&
            !valueChangedFromInput.current) {
            setRenderCount(function (r) { return r + 1; });
            parse
                ? field.onChange(parse(field.value))
                : field.onChange(field.value);
            initialDefaultValueRef.current = field.value;
            valueChangedFromInput.current = false;
        }
    }, [setRenderCount, parse, field]);
    var onBlurFromField = field.onBlur;
    var hasFocus = React.useRef(false);
    // update the input text when the user types in the input
    var handleChange = function (event) {
        if (onChange) {
            onChange(event);
        }
        if (typeof event.target === 'undefined' ||
            typeof event.target.value === 'undefined') {
            return;
        }
        var target = event.target;
        var newValue = target.valueAsDate !== undefined &&
            target.valueAsDate !== null &&
            !isNaN(new Date(target.valueAsDate).getTime())
            ? parse
                ? parse(target.valueAsDate)
                : target.valueAsDate
            : parse
                ? parse(target.value)
                : formatDateTime(target.value);
        // Some browsers will return null for an invalid date so we only change react-hook-form value if it's not null
        // The input reset is handled in the onBlur event handler
        if (newValue !== '' && newValue != null) {
            field.onChange(newValue);
            valueChangedFromInput.current = true;
        }
    };
    var handleFocus = function (event) {
        if (onFocus) {
            onFocus(event);
        }
        hasFocus.current = true;
    };
    var handleBlur = function () {
        hasFocus.current = false;
        if (!localInputRef.current) {
            return;
        }
        // To ensure users can clear the input, we check its value on blur
        // and submit it to react-hook-form
        var newValue = localInputRef.current.valueAsDate !== undefined &&
            localInputRef.current.valueAsDate !== null &&
            !isNaN(new Date(localInputRef.current.valueAsDate).getTime())
            ? parse
                ? parse(localInputRef.current.valueAsDate)
                : formatDateTime(localInputRef.current.valueAsDate)
            : parse
                ? parse(localInputRef.current.value)
                : formatDateTime(localInputRef.current.value);
        if (newValue !== field.value) {
            field.onChange(newValue !== null && newValue !== void 0 ? newValue : '');
        }
        if (onBlurFromField) {
            onBlurFromField();
        }
    };
    var error = fieldState.error, invalid = fieldState.invalid;
    var renderHelperText = helperText !== false || invalid;
    var ref = field.ref, name = field.name;
    var inputRef = mergeRefs([ref, localInputRef]);
    return (React.createElement(TextField, __assign({ id: id, inputRef: inputRef, name: name, defaultValue: format(initialDefaultValueRef.current), key: renderCount, type: "datetime-local", onChange: handleChange, onFocus: handleFocus, onBlur: handleBlur, className: clsx('ra-input', "ra-input-".concat(source), className), size: "small", variant: variant, margin: margin, error: invalid, disabled: disabled || readOnly, readOnly: readOnly, helperText: renderHelperText ? (React.createElement(InputHelperText, { error: error === null || error === void 0 ? void 0 : error.message, helperText: helperText })) : null, label: React.createElement(FieldTitle, { label: label, source: source, resource: resource, isRequired: isRequired }), InputLabelProps: defaultInputLabelProps }, sanitizeInputRestProps(rest))));
};
var leftPad = function (nb) {
    if (nb === void 0) { nb = 2; }
    return function (value) {
        return ('0'.repeat(nb) + value).slice(-nb);
    };
};
var leftPad4 = leftPad(4);
var leftPad2 = leftPad(2);
/**
 * @param {Date} value value to convert
 * @returns {String} A standardized datetime (yyyy-MM-ddThh:mm), to be passed to an <input type="datetime-local" />
 */
var convertDateToString = function (value) {
    if (!(value instanceof Date) || isNaN(value.getDate()))
        return '';
    var yyyy = leftPad4(value.getFullYear());
    var MM = leftPad2(value.getMonth() + 1);
    var dd = leftPad2(value.getDate());
    var hh = leftPad2(value.getHours());
    var mm = leftPad2(value.getMinutes());
    return "".concat(yyyy, "-").concat(MM, "-").concat(dd, "T").concat(hh, ":").concat(mm);
};
// yyyy-MM-ddThh:mm
var dateTimeRegex = /^\d{4}-\d{2}-\d{2}T\d{2}:\d{2}$/;
var defaultInputLabelProps = { shrink: true };
/**
 * Converts a date from the dataProvider, with timezone, to a date string
 * without timezone for use in an <input type="datetime-local" />.
 *
 * @param {Date | String} value date string or object
 */
var formatDateTime = function (value) {
    // null, undefined and empty string values should not go through convertDateToString
    // otherwise, it returns undefined and will make the input an uncontrolled one.
    if (value == null || value === '') {
        return '';
    }
    if (value instanceof Date) {
        return convertDateToString(value);
    }
    // valid dates should not be converted
    if (dateTimeRegex.test(value)) {
        return value;
    }
    return convertDateToString(new Date(value));
};
//# sourceMappingURL=DateTimeInput.js.map