import React, { FC, ReactNode } from 'react';
import { DropzoneOptions } from 'react-dropzone';
import { CommonInputProps } from './CommonInputProps';
import { SxProps } from '@mui/system';
import { SvgIconProps } from '@mui/material';
export declare const FileInput: (props: FileInputProps) => React.JSX.Element;
export declare const FileInputClasses: {
    dropZone: string;
    removeButton: string;
};
export type FileInputProps = CommonInputProps & {
    accept?: DropzoneOptions['accept'];
    className?: string;
    children?: ReactNode;
    labelMultiple?: string;
    labelSingle?: string;
    maxSize?: DropzoneOptions['maxSize'];
    minSize?: DropzoneOptions['minSize'];
    multiple?: DropzoneOptions['multiple'];
    options?: DropzoneOptions;
    onRemove?: Function;
    placeholder?: ReactNode;
    removeIcon?: FC<SvgIconProps>;
    inputProps?: any;
    validateFileRemoval?(file: any): boolean | Promise<boolean>;
    sx?: SxProps;
};
//# sourceMappingURL=FileInput.d.ts.map