var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __generator = (this && this.__generator) || function (thisArg, body) {
    var _ = { label: 0, sent: function() { if (t[0] & 1) throw t[1]; return t[1]; }, trys: [], ops: [] }, f, y, t, g;
    return g = { next: verb(0), "throw": verb(1), "return": verb(2) }, typeof Symbol === "function" && (g[Symbol.iterator] = function() { return this; }), g;
    function verb(n) { return function (v) { return step([n, v]); }; }
    function step(op) {
        if (f) throw new TypeError("Generator is already executing.");
        while (g && (g = 0, op[0] && (_ = 0)), _) try {
            if (f = 1, y && (t = op[0] & 2 ? y["return"] : op[0] ? y["throw"] || ((t = y["return"]) && t.call(y), 0) : y.next) && !(t = t.call(y, op[1])).done) return t;
            if (y = 0, t) op = [op[0] & 2, t.value];
            switch (op[0]) {
                case 0: case 1: t = op; break;
                case 4: _.label++; return { value: op[1], done: false };
                case 5: _.label++; y = op[1]; op = [0]; continue;
                case 7: op = _.ops.pop(); _.trys.pop(); continue;
                default:
                    if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) { _ = 0; continue; }
                    if (op[0] === 3 && (!t || (op[1] > t[0] && op[1] < t[3]))) { _.label = op[1]; break; }
                    if (op[0] === 6 && _.label < t[1]) { _.label = t[1]; t = op; break; }
                    if (t && _.label < t[2]) { _.label = t[2]; _.ops.push(op); break; }
                    if (t[2]) _.ops.pop();
                    _.trys.pop(); continue;
            }
            op = body.call(thisArg, _);
        } catch (e) { op = [6, e]; y = 0; } finally { f = t = 0; }
        if (op[0] & 5) throw op[1]; return { value: op[0] ? op[1] : void 0, done: true };
    }
};
var __rest = (this && this.__rest) || function (s, e) {
    var t = {};
    for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p) && e.indexOf(p) < 0)
        t[p] = s[p];
    if (s != null && typeof Object.getOwnPropertySymbols === "function")
        for (var i = 0, p = Object.getOwnPropertySymbols(s); i < p.length; i++) {
            if (e.indexOf(p[i]) < 0 && Object.prototype.propertyIsEnumerable.call(s, p[i]))
                t[p[i]] = s[p[i]];
        }
    return t;
};
var __spreadArray = (this && this.__spreadArray) || function (to, from, pack) {
    if (pack || arguments.length === 2) for (var i = 0, l = from.length, ar; i < l; i++) {
        if (ar || !(i in from)) {
            if (!ar) ar = Array.prototype.slice.call(from, 0, i);
            ar[i] = from[i];
        }
    }
    return to.concat(ar || Array.prototype.slice.call(from));
};
import React, { Children, isValidElement, } from 'react';
import { styled } from '@mui/material/styles';
import clsx from 'clsx';
import { useDropzone } from 'react-dropzone';
import FormHelperText from '@mui/material/FormHelperText';
import { useInput, useTranslate, shallowEqual, RecordContextProvider, } from 'ra-core';
import { Labeled } from '../Labeled';
import { FileInputPreview } from './FileInputPreview';
import { sanitizeInputRestProps } from './sanitizeInputRestProps';
import { InputHelperText } from './InputHelperText';
import { useTheme } from '@mui/material/styles';
export var FileInput = function (props) {
    var accept = props.accept, children = props.children, className = props.className, format = props.format, helperText = props.helperText, inputPropsOptions = props.inputProps, maxSize = props.maxSize, minSize = props.minSize, _a = props.multiple, multiple = _a === void 0 ? false : _a, label = props.label, _b = props.labelMultiple, labelMultiple = _b === void 0 ? 'ra.input.file.upload_several' : _b, _c = props.labelSingle, labelSingle = _c === void 0 ? 'ra.input.file.upload_single' : _c, _d = props.options, options = _d === void 0 ? {} : _d, onRemoveProp = props.onRemove, parse = props.parse, placeholder = props.placeholder, removeIcon = props.removeIcon, resource = props.resource, source = props.source, validate = props.validate, validateFileRemoval = props.validateFileRemoval, disabled = props.disabled, readOnly = props.readOnly, rest = __rest(props, ["accept", "children", "className", "format", "helperText", "inputProps", "maxSize", "minSize", "multiple", "label", "labelMultiple", "labelSingle", "options", "onRemove", "parse", "placeholder", "removeIcon", "resource", "source", "validate", "validateFileRemoval", "disabled", "readOnly"]);
    var onDropProp = options.onDrop;
    var translate = useTranslate();
    // turn a browser dropped file structure into expected structure
    var transformFile = function (file) {
        if (!(file instanceof File)) {
            return file;
        }
        var preview = URL.createObjectURL(file);
        var transformedFile = {
            rawFile: file,
            src: preview,
            title: file.name,
        };
        return transformedFile;
    };
    var transformFiles = function (files) {
        if (!files) {
            return multiple ? [] : null;
        }
        if (Array.isArray(files)) {
            return files.map(transformFile);
        }
        return transformFile(files);
    };
    var _e = useInput(__assign({ format: format || transformFiles, parse: parse || transformFiles, source: source, validate: validate, disabled: disabled, readOnly: readOnly }, rest)), id = _e.id, _f = _e.field, onChange = _f.onChange, onBlur = _f.onBlur, value = _f.value, fieldState = _e.fieldState, isRequired = _e.isRequired;
    var error = fieldState.error, invalid = fieldState.invalid;
    var files = value ? (Array.isArray(value) ? value : [value]) : [];
    var onDrop = function (newFiles, rejectedFiles, event) {
        var updatedFiles = multiple ? __spreadArray(__spreadArray([], files, true), newFiles, true) : __spreadArray([], newFiles, true);
        if (multiple) {
            onChange(updatedFiles);
            onBlur();
        }
        else {
            onChange(updatedFiles[0]);
            onBlur();
        }
        if (onDropProp) {
            onDropProp(newFiles, rejectedFiles, event);
        }
    };
    var onRemove = function (file) { return function () { return __awaiter(void 0, void 0, void 0, function () {
        var e_1, filteredFiles;
        return __generator(this, function (_a) {
            switch (_a.label) {
                case 0:
                    if (!validateFileRemoval) return [3 /*break*/, 4];
                    _a.label = 1;
                case 1:
                    _a.trys.push([1, 3, , 4]);
                    return [4 /*yield*/, validateFileRemoval(file)];
                case 2:
                    _a.sent();
                    return [3 /*break*/, 4];
                case 3:
                    e_1 = _a.sent();
                    return [2 /*return*/];
                case 4:
                    if (multiple) {
                        filteredFiles = files.filter(function (stateFile) { return !shallowEqual(stateFile, file); });
                        onChange(filteredFiles);
                        onBlur();
                    }
                    else {
                        onChange(null);
                        onBlur();
                    }
                    if (onRemoveProp) {
                        onRemoveProp(file);
                    }
                    return [2 /*return*/];
            }
        });
    }); }; };
    var childrenElement = children && isValidElement(Children.only(children))
        ? Children.only(children)
        : undefined;
    var _g = useDropzone(__assign(__assign({ accept: accept, maxSize: maxSize, minSize: minSize, multiple: multiple, disabled: disabled || readOnly }, options), { onDrop: onDrop })), getRootProps = _g.getRootProps, getInputProps = _g.getInputProps;
    var renderHelperText = helperText !== false || invalid;
    var theme = useTheme();
    return (React.createElement(StyledLabeled, __assign({ htmlFor: id, label: label, className: clsx('ra-input', "ra-input-".concat(source), className), source: source, resource: resource, isRequired: isRequired, color: invalid ? 'error' : undefined, sx: __assign({ cursor: disabled || readOnly ? 'default' : 'pointer' }, rest.sx) }, sanitizeInputRestProps(rest)),
        React.createElement(React.Fragment, null,
            React.createElement("div", __assign({}, getRootProps({
                className: FileInputClasses.dropZone,
                'data-testid': 'dropzone',
                style: {
                    color: disabled || readOnly
                        ? theme.palette.text.disabled
                        : (inputPropsOptions === null || inputPropsOptions === void 0 ? void 0 : inputPropsOptions.color) ||
                            theme.palette.text.primary,
                    backgroundColor: disabled || readOnly
                        ? theme.palette.action.disabledBackground
                        : inputPropsOptions === null || inputPropsOptions === void 0 ? void 0 : inputPropsOptions.backgroundColor,
                },
            })),
                React.createElement("input", __assign({ id: id, name: id }, getInputProps(__assign({}, inputPropsOptions)))),
                placeholder ? (placeholder) : multiple ? (React.createElement("p", null, translate(labelMultiple))) : (React.createElement("p", null, translate(labelSingle)))),
            renderHelperText ? (React.createElement(FormHelperText, { error: invalid },
                React.createElement(InputHelperText, { error: error === null || error === void 0 ? void 0 : error.message, helperText: helperText }))) : null,
            children && (React.createElement("div", { className: "previews" }, files.map(function (file, index) { return (React.createElement(FileInputPreview, { key: index, file: file, onRemove: onRemove(file), className: FileInputClasses.removeButton, removeIcon: removeIcon },
                React.createElement(RecordContextProvider, { value: file }, childrenElement))); }))))));
};
var PREFIX = 'RaFileInput';
export var FileInputClasses = {
    dropZone: "".concat(PREFIX, "-dropZone"),
    removeButton: "".concat(PREFIX, "-removeButton"),
};
var StyledLabeled = styled(Labeled, {
    name: PREFIX,
    overridesResolver: function (props, styles) { return styles.root; },
})(function (_a) {
    var _b;
    var theme = _a.theme;
    return (_b = {
            width: '100%'
        },
        _b["& .".concat(FileInputClasses.dropZone)] = {
            background: theme.palette.background.default,
            borderRadius: theme.shape.borderRadius,
            fontFamily: theme.typography.fontFamily,
            padding: theme.spacing(1),
            textAlign: 'center',
            color: theme.palette.getContrastText(theme.palette.background.default),
        },
        _b["& .".concat(FileInputClasses.removeButton)] = {},
        _b);
});
//# sourceMappingURL=FileInput.js.map