var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
var __rest = (this && this.__rest) || function (s, e) {
    var t = {};
    for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p) && e.indexOf(p) < 0)
        t[p] = s[p];
    if (s != null && typeof Object.getOwnPropertySymbols === "function")
        for (var i = 0, p = Object.getOwnPropertySymbols(s); i < p.length; i++) {
            if (e.indexOf(p[i]) < 0 && Object.prototype.propertyIsEnumerable.call(s, p[i]))
                t[p[i]] = s[p[i]];
        }
    return t;
};
import * as React from 'react';
import { styled } from '@mui/material/styles';
import TextField from '@mui/material/TextField';
import MenuItem from '@mui/material/MenuItem';
import clsx from 'clsx';
import { useInput, useTranslate, FieldTitle } from 'ra-core';
import { sanitizeInputRestProps } from './sanitizeInputRestProps';
import { InputHelperText } from './InputHelperText';
export var NullableBooleanInput = function (props) {
    var className = props.className, _a = props.format, format = _a === void 0 ? getStringFromBoolean : _a, helperText = props.helperText, label = props.label, margin = props.margin, onBlur = props.onBlur, onChange = props.onChange, _b = props.parse, parse = _b === void 0 ? getBooleanFromString : _b, resource = props.resource, disabled = props.disabled, readOnly = props.readOnly, source = props.source, validate = props.validate, variant = props.variant, _c = props.nullLabel, nullLabel = _c === void 0 ? 'ra.boolean.null' : _c, _d = props.falseLabel, falseLabel = _d === void 0 ? 'ra.boolean.false' : _d, _e = props.trueLabel, trueLabel = _e === void 0 ? 'ra.boolean.true' : _e, rest = __rest(props, ["className", "format", "helperText", "label", "margin", "onBlur", "onChange", "parse", "resource", "disabled", "readOnly", "source", "validate", "variant", "nullLabel", "falseLabel", "trueLabel"]);
    var translate = useTranslate();
    var _f = useInput(__assign({ format: format, parse: parse, onBlur: onBlur, onChange: onChange, resource: resource, source: source, validate: validate, disabled: disabled, readOnly: readOnly }, rest)), field = _f.field, _g = _f.fieldState, error = _g.error, invalid = _g.invalid, id = _f.id, isRequired = _f.isRequired;
    var renderHelperText = helperText !== false || invalid;
    return (React.createElement(StyledTextField, __assign({ id: id, size: "small" }, field, { className: clsx('ra-input', "ra-input-".concat(source), NullableBooleanInputClasses.input, className), select: true, disabled: disabled || readOnly, readOnly: readOnly, margin: margin, label: React.createElement(FieldTitle, { label: label, source: source, resource: resource, isRequired: isRequired }), error: invalid, helperText: renderHelperText ? (React.createElement(InputHelperText, { error: error === null || error === void 0 ? void 0 : error.message, helperText: helperText })) : null, variant: variant }, sanitizeInputRestProps(rest)),
        React.createElement(MenuItem, { value: "" }, translate(nullLabel)),
        React.createElement(MenuItem, { value: "false" }, translate(falseLabel)),
        React.createElement(MenuItem, { value: "true" }, translate(trueLabel))));
};
var PREFIX = 'RaNullableBooleanInput';
export var NullableBooleanInputClasses = {
    input: "".concat(PREFIX, "-input"),
};
var StyledTextField = styled(TextField, {
    name: PREFIX,
    overridesResolver: function (props, styles) { return styles.root; },
})(function (_a) {
    var _b, _c;
    var theme = _a.theme;
    return (_b = {
            minWidth: theme.spacing(20)
        },
        _b[theme.breakpoints.down('sm')] = (_c = {},
            _c["&.".concat(NullableBooleanInputClasses.input)] = {
                width: '100%',
            },
            _c),
        _b);
});
var getBooleanFromString = function (value) {
    if (value === 'true')
        return true;
    if (value === 'false')
        return false;
    return null;
};
var getStringFromBoolean = function (value) {
    if (value === true)
        return 'true';
    if (value === false)
        return 'false';
    return '';
};
//# sourceMappingURL=NullableBooleanInput.js.map