var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __generator = (this && this.__generator) || function (thisArg, body) {
    var _ = { label: 0, sent: function() { if (t[0] & 1) throw t[1]; return t[1]; }, trys: [], ops: [] }, f, y, t, g;
    return g = { next: verb(0), "throw": verb(1), "return": verb(2) }, typeof Symbol === "function" && (g[Symbol.iterator] = function() { return this; }), g;
    function verb(n) { return function (v) { return step([n, v]); }; }
    function step(op) {
        if (f) throw new TypeError("Generator is already executing.");
        while (g && (g = 0, op[0] && (_ = 0)), _) try {
            if (f = 1, y && (t = op[0] & 2 ? y["return"] : op[0] ? y["throw"] || ((t = y["return"]) && t.call(y), 0) : y.next) && !(t = t.call(y, op[1])).done) return t;
            if (y = 0, t) op = [op[0] & 2, t.value];
            switch (op[0]) {
                case 0: case 1: t = op; break;
                case 4: _.label++; return { value: op[1], done: false };
                case 5: _.label++; y = op[1]; op = [0]; continue;
                case 7: op = _.ops.pop(); _.trys.pop(); continue;
                default:
                    if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) { _ = 0; continue; }
                    if (op[0] === 3 && (!t || (op[1] > t[0] && op[1] < t[3]))) { _.label = op[1]; break; }
                    if (op[0] === 6 && _.label < t[1]) { _.label = t[1]; t = op; break; }
                    if (t && _.label < t[2]) { _.label = t[2]; _.ops.push(op); break; }
                    if (t[2]) _.ops.pop();
                    _.trys.pop(); continue;
            }
            op = body.call(thisArg, _);
        } catch (e) { op = [6, e]; y = 0; } finally { f = t = 0; }
        if (op[0] & 5) throw op[1]; return { value: op[0] ? op[1] : void 0, done: true };
    }
};
var __rest = (this && this.__rest) || function (s, e) {
    var t = {};
    for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p) && e.indexOf(p) < 0)
        t[p] = s[p];
    if (s != null && typeof Object.getOwnPropertySymbols === "function")
        for (var i = 0, p = Object.getOwnPropertySymbols(s); i < p.length; i++) {
            if (e.indexOf(p[i]) < 0 && Object.prototype.propertyIsEnumerable.call(s, p[i]))
                t[p[i]] = s[p[i]];
        }
    return t;
};
var __spreadArray = (this && this.__spreadArray) || function (to, from, pack) {
    if (pack || arguments.length === 2) for (var i = 0, l = from.length, ar; i < l; i++) {
        if (ar || !(i in from)) {
            if (!ar) ar = Array.prototype.slice.call(from, 0, i);
            ar[i] = from[i];
        }
    }
    return to.concat(ar || Array.prototype.slice.call(from));
};
import * as React from 'react';
import { useCallback, useEffect } from 'react';
import clsx from 'clsx';
import { MenuItem } from '@mui/material';
import { styled } from '@mui/material/styles';
import { useChoicesContext, useInput, FieldTitle, useTranslate, useChoices, useGetRecordRepresentation, } from 'ra-core';
import { ResettableTextField, ResettableTextFieldStyles, } from './ResettableTextField';
import { InputHelperText } from './InputHelperText';
import { sanitizeInputRestProps } from './sanitizeInputRestProps';
import { useSupportCreateSuggestion, } from './useSupportCreateSuggestion';
import { LoadingInput } from './LoadingInput';
/**
 * An Input component for a select box, using an array of objects for the options
 *
 * Pass possible options as an array of objects in the 'choices' attribute.
 *
 * By default, the options are built from:
 *  - the 'id' property as the option value,
 *  - the 'name' property as the option text
 * @example
 * const choices = [
 *    { id: 'M', name: 'Male' },
 *    { id: 'F', name: 'Female' },
 * ];
 * <SelectInput source="gender" choices={choices} />
 *
 * You can also customize the properties to use for the option name and value,
 * thanks to the 'optionText' and 'optionValue' attributes.
 * @example
 * const choices = [
 *    { _id: 123, full_name: 'Leo Tolstoi', sex: 'M' },
 *    { _id: 456, full_name: 'Jane Austen', sex: 'F' },
 * ];
 * <SelectInput source="author_id" choices={choices} optionText="full_name" optionValue="_id" />
 *
 * `optionText` also accepts a function, so you can shape the option text at will:
 * @example
 * const choices = [
 *    { id: 123, first_name: 'Leo', last_name: 'Tolstoi' },
 *    { id: 456, first_name: 'Jane', last_name: 'Austen' },
 * ];
 * const optionRenderer = choice => `${choice.first_name} ${choice.last_name}`;
 * <SelectInput source="author_id" choices={choices} optionText={optionRenderer} />
 *
 * `optionText` also accepts a React Element, that can access
 * the related choice through the `useRecordContext` hook. You can use Field components there.
 * @example
 * const choices = [
 *    { id: 123, first_name: 'Leo', last_name: 'Tolstoi' },
 *    { id: 456, first_name: 'Jane', last_name: 'Austen' },
 * ];
 * const FullNameField = () => {
 *     const record = useRecordContext();
 *     return <span>{record.first_name} {record.last_name}</span>;
 * }
 * <SelectInput source="author" choices={choices} optionText={<FullNameField />}/>
 *
 * The choices are translated by default, so you can use translation identifiers as choices:
 * @example
 * const choices = [
 *    { id: 'M', name: 'myroot.gender.male' },
 *    { id: 'F', name: 'myroot.gender.female' },
 * ];
 *
 * However, in some cases (e.g. inside a `<ReferenceInput>`), you may not want
 * the choice to be translated. In that case, set the `translateChoice` prop to false.
 * @example
 * <SelectInput source="gender" choices={choices} translateChoice={false}/>
 *
 * You can disable some choices by providing a `disableValue` field which name is `disabled` by default
 * @example
 * const choices = [
 *    { id: 123, first_name: 'Leo', last_name: 'Tolstoi' },
 *    { id: 456, first_name: 'Jane', last_name: 'Austen' },
 *    { id: 976, first_name: 'William', last_name: 'Rinkerd', disabled: true },
 * ];
 *
 * @example
 * const choices = [
 *    { id: 123, first_name: 'Leo', last_name: 'Tolstoi' },
 *    { id: 456, first_name: 'Jane', last_name: 'Austen' },
 *    { id: 976, first_name: 'William', last_name: 'Rinkerd', not_available: true },
 * ];
 * <SelectInput source="gender" choices={choices} disableValue="not_available" />
 *
 */
export var SelectInput = function (props) {
    var choicesProp = props.choices, className = props.className, create = props.create, createLabel = props.createLabel, createValue = props.createValue, defaultValue = props.defaultValue, _a = props.disableValue, disableValue = _a === void 0 ? 'disabled' : _a, _b = props.emptyText, emptyText = _b === void 0 ? '' : _b, _c = props.emptyValue, emptyValue = _c === void 0 ? '' : _c, format = props.format, filter = props.filter, helperText = props.helperText, isFetchingProp = props.isFetching, isLoadingProp = props.isLoading, isPendingProp = props.isPending, label = props.label, _d = props.margin, margin = _d === void 0 ? 'dense' : _d, onBlur = props.onBlur, onChange = props.onChange, onCreate = props.onCreate, optionText = props.optionText, optionValue = props.optionValue, parse = props.parse, resourceProp = props.resource, sourceProp = props.source, translateChoice = props.translateChoice, validate = props.validate, rest = __rest(props, ["choices", "className", "create", "createLabel", "createValue", "defaultValue", "disableValue", "emptyText", "emptyValue", "format", "filter", "helperText", "isFetching", "isLoading", "isPending", "label", "margin", "onBlur", "onChange", "onCreate", "optionText", "optionValue", "parse", "resource", "source", "translateChoice", "validate"]);
    var translate = useTranslate();
    useEffect(function () {
        // eslint-disable-next-line eqeqeq
        if (emptyValue == null) {
            throw new Error("emptyValue being set to null or undefined is not supported. Use parse to turn the empty string into null.");
        }
    }, [emptyValue]);
    var _e = useChoicesContext({
        choices: choicesProp,
        isLoading: isLoadingProp,
        isFetching: isFetchingProp,
        isPending: isPendingProp,
        resource: resourceProp,
        source: sourceProp,
    }), allChoices = _e.allChoices, isPending = _e.isPending, fetchError = _e.error, source = _e.source, resource = _e.resource, isFromReference = _e.isFromReference;
    if (source === undefined) {
        throw new Error("If you're not wrapping the SelectInput inside a ReferenceInput, you must provide the source prop");
    }
    if (!isPending && !fetchError && allChoices === undefined) {
        throw new Error("If you're not wrapping the SelectInput inside a ReferenceInput, you must provide the choices prop");
    }
    var getRecordRepresentation = useGetRecordRepresentation(resource);
    var _f = useChoices({
        optionText: optionText !== null && optionText !== void 0 ? optionText : (isFromReference ? getRecordRepresentation : undefined),
        optionValue: optionValue,
        disableValue: disableValue,
        translateChoice: translateChoice !== null && translateChoice !== void 0 ? translateChoice : !isFromReference,
    }), getChoiceText = _f.getChoiceText, getChoiceValue = _f.getChoiceValue, getDisableValue = _f.getDisableValue;
    var _g = useInput(__assign({ defaultValue: defaultValue, parse: parse, format: format, onBlur: onBlur, onChange: onChange, resource: resource, source: source, validate: validate }, rest)), field = _g.field, fieldState = _g.fieldState, id = _g.id, isRequired = _g.isRequired;
    var error = fieldState.error, invalid = fieldState.invalid;
    var renderEmptyItemOption = useCallback(function () {
        return typeof emptyText === 'string'
            ? emptyText === ''
                ? ' ' // em space, forces the display of an empty line of normal height
                : translate(emptyText, { _: emptyText })
            : emptyText;
    }, [emptyText, translate]);
    var renderMenuItemOption = useCallback(function (choice) { return getChoiceText(choice); }, [getChoiceText]);
    var handleChange = useCallback(function (eventOrChoice) { return __awaiter(void 0, void 0, void 0, function () {
        return __generator(this, function (_a) {
            if (typeof eventOrChoice === 'string') {
                if (eventOrChoice === '') {
                    // called  by the reset button
                    field.onChange(emptyValue);
                }
            }
            else if (eventOrChoice === null || eventOrChoice === void 0 ? void 0 : eventOrChoice.target) {
                // We might receive an event from the mui component
                // In this case, it will be the choice id
                field.onChange(eventOrChoice);
            }
            else {
                // Or we might receive a choice directly, for instance a newly created one
                field.onChange(getChoiceValue(eventOrChoice));
            }
            return [2 /*return*/];
        });
    }); }, [field, getChoiceValue, emptyValue]);
    var _h = useSupportCreateSuggestion({
        create: create,
        createLabel: createLabel,
        createValue: createValue,
        handleChange: handleChange,
        onCreate: onCreate,
        optionText: optionText,
    }), getCreateItem = _h.getCreateItem, handleChangeWithCreateSupport = _h.handleChange, createElement = _h.createElement;
    var createItem = create || onCreate ? getCreateItem() : null;
    var renderMenuItem = useCallback(function (choice) {
        return choice ? (React.createElement(MenuItem, { key: getChoiceValue(choice), value: getChoiceValue(choice), disabled: getDisableValue(choice) }, renderMenuItemOption(!!createItem && (choice === null || choice === void 0 ? void 0 : choice.id) === createItem.id
            ? createItem
            : choice))) : null;
    }, [getChoiceValue, getDisableValue, renderMenuItemOption, createItem]);
    if (isPending) {
        return (React.createElement(LoadingInput, { label: label !== '' &&
                label !== false && (React.createElement(FieldTitle, { label: label, source: source, resource: resourceProp, isRequired: isRequired })), sx: props.sx, helperText: React.createElement(InputHelperText, { error: error === null || error === void 0 ? void 0 : error.message, helperText: helperText }), variant: props.variant, size: props.size, margin: props.margin, fullWidth: props.fullWidth }));
    }
    var finalChoices = fetchError ? [] : allChoices;
    if (create || onCreate) {
        finalChoices = __spreadArray(__spreadArray([], finalChoices, true), [createItem], false);
    }
    var renderHelperText = !!fetchError || helperText !== false || invalid;
    return (React.createElement(React.Fragment, null,
        React.createElement(StyledResettableTextField, __assign({ id: id }, field, { className: clsx('ra-input', "ra-input-".concat(source), className), onChange: handleChangeWithCreateSupport, select: true, label: label !== '' &&
                label !== false && (React.createElement(FieldTitle, { label: label, source: source, resource: resourceProp, isRequired: isRequired })), clearAlwaysVisible: true, error: !!fetchError || invalid, helperText: renderHelperText ? (React.createElement(InputHelperText, { error: (error === null || error === void 0 ? void 0 : error.message) || (fetchError === null || fetchError === void 0 ? void 0 : fetchError.message), helperText: helperText })) : null, margin: margin }, sanitizeRestProps(rest)),
            !isRequired && (React.createElement(MenuItem, { value: emptyValue, key: "null", "aria-label": translate('ra.action.clear_input_value'), title: translate('ra.action.clear_input_value') }, renderEmptyItemOption())),
            finalChoices.map(renderMenuItem)),
        createElement));
};
var sanitizeRestProps = function (_a) {
    var afterSubmit = _a.afterSubmit, allowNull = _a.allowNull, beforeSubmit = _a.beforeSubmit, choices = _a.choices, className = _a.className, crudGetMatching = _a.crudGetMatching, crudGetOne = _a.crudGetOne, data = _a.data, field = _a.field, fieldState = _a.fieldState, formState = _a.formState, filter = _a.filter, filterToQuery = _a.filterToQuery, formatOnBlur = _a.formatOnBlur, isEqual = _a.isEqual, limitChoicesToValue = _a.limitChoicesToValue, multiple = _a.multiple, name = _a.name, pagination = _a.pagination, perPage = _a.perPage, ref = _a.ref, reference = _a.reference, refetch = _a.refetch, render = _a.render, setFilter = _a.setFilter, setPagination = _a.setPagination, setSort = _a.setSort, shouldUnregister = _a.shouldUnregister, sort = _a.sort, subscription = _a.subscription, type = _a.type, validateFields = _a.validateFields, validation = _a.validation, value = _a.value, rest = __rest(_a, ["afterSubmit", "allowNull", "beforeSubmit", "choices", "className", "crudGetMatching", "crudGetOne", "data", "field", "fieldState", "formState", "filter", "filterToQuery", "formatOnBlur", "isEqual", "limitChoicesToValue", "multiple", "name", "pagination", "perPage", "ref", "reference", "refetch", "render", "setFilter", "setPagination", "setSort", "shouldUnregister", "sort", "subscription", "type", "validateFields", "validation", "value"]);
    return sanitizeInputRestProps(rest);
};
var PREFIX = 'RaSelectInput';
var StyledResettableTextField = styled(ResettableTextField, {
    name: PREFIX,
    overridesResolver: function (props, styles) { return styles.root; },
})(function (_a) {
    var theme = _a.theme;
    return (__assign(__assign({}, ResettableTextFieldStyles), { minWidth: theme.spacing(20), '& .MuiFilledInput-root': { paddingRight: 0 } }));
});
//# sourceMappingURL=SelectInput.js.map