import * as React from 'react';
import { CommonInputProps } from './CommonInputProps';
import { ResettableTextFieldProps } from './ResettableTextField';
/**
 * An Input component for a string
 *
 * @example
 * <TextInput source="first_name" />
 *
 * You can customize the `type` props (which defaults to "text").
 * Note that, due to a React bug, you should use `<NumberField>` instead of using type="number".
 * @example
 * <TextInput source="email" type="email" />
 * <NumberInput source="nb_views" />
 *
 */
export declare const TextInput: (props: TextInputProps) => React.JSX.Element;
export type TextInputProps = CommonInputProps & Omit<ResettableTextFieldProps, 'label' | 'helperText'>;
//# sourceMappingURL=TextInput.d.ts.map