import { SxProps } from '@mui/material/styles';
import { StackProps } from '@mui/material';
import { ReactElement, ReactNode } from 'react';
import { UseTranslatableOptions } from 'ra-core';
/**
 * Provides a way to edit multiple languages for any input passed as children.
 * It expects the translatable values to have the following structure:
 * {
 *     name: {
 *         en: 'The english value',
 *         fr: 'The french value',
 *         tlh: 'The klingon value',
 *     },
 *     description: {
 *         en: 'The english value',
 *         fr: 'The french value',
 *         tlh: 'The klingon value',
 *     }
 * }
 *
 * @example <caption>Basic usage</caption>
 * <TranslatableInputs locales={['en', 'fr']}>
 *     <TextInput source="title" />
 *     <RichTextInput source="description" />
 * </TranslatableInputs>
 *
 * @example <caption>With a custom language selector</caption>
 * <TranslatableInputs
 *     selector={<MyLanguageSelector />}
 *     locales={['en', 'fr']}
 * >
 *     <TextInput source="title" />
 * </TranslatableInputs>
 *
 * const MyLanguageSelector = () => {
 *     const {
 *         locales,
 *         selectedLocale,
 *         selectLocale,
 *     } = useTranslatableContext();
 *
 *     return (
 *         <select onChange={event => selectLocale(event.target.value)}>
 *             {locales.map((locale) => (
 *                 <option selected={locale === selectedLocale}>
 *                     {locale}
 *                 </option>
 *             ))}
 *        </select>
 *     );
 * }
 *
 * @param props The component props
 * @param {string} props.defaultLocale The locale selected by default. Default to 'en'.
 * @param {string[]} props.locales An array of the possible locales. For example: `['en', 'fr'].
 * @param {ReactElement} props.selector The element responsible for selecting a locale. Defaults to Material UI tabs.
 */
export declare const TranslatableInputs: (inProps: TranslatableInputsProps) => ReactElement;
export interface TranslatableInputsProps extends UseTranslatableOptions {
    className?: string;
    selector?: ReactElement;
    children: ReactNode;
    fullWidth?: boolean;
    groupKey?: string;
    margin?: 'none' | 'normal' | 'dense';
    sx?: SxProps;
    StackProps?: StackProps;
}
export declare const TranslatableInputsClasses: {
    root: string;
    fullWidth: string;
};
//# sourceMappingURL=TranslatableInputs.d.ts.map