var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
import * as React from 'react';
import { styled } from '@mui/material/styles';
import { useThemeProps } from '@mui/material';
import { TranslatableContextProvider, useTranslatable, } from 'ra-core';
import clsx from 'clsx';
import { TranslatableInputsTabs } from './TranslatableInputsTabs';
import { TranslatableInputsTabContent } from './TranslatableInputsTabContent';
/**
 * Provides a way to edit multiple languages for any input passed as children.
 * It expects the translatable values to have the following structure:
 * {
 *     name: {
 *         en: 'The english value',
 *         fr: 'The french value',
 *         tlh: 'The klingon value',
 *     },
 *     description: {
 *         en: 'The english value',
 *         fr: 'The french value',
 *         tlh: 'The klingon value',
 *     }
 * }
 *
 * @example <caption>Basic usage</caption>
 * <TranslatableInputs locales={['en', 'fr']}>
 *     <TextInput source="title" />
 *     <RichTextInput source="description" />
 * </TranslatableInputs>
 *
 * @example <caption>With a custom language selector</caption>
 * <TranslatableInputs
 *     selector={<MyLanguageSelector />}
 *     locales={['en', 'fr']}
 * >
 *     <TextInput source="title" />
 * </TranslatableInputs>
 *
 * const MyLanguageSelector = () => {
 *     const {
 *         locales,
 *         selectedLocale,
 *         selectLocale,
 *     } = useTranslatableContext();
 *
 *     return (
 *         <select onChange={event => selectLocale(event.target.value)}>
 *             {locales.map((locale) => (
 *                 <option selected={locale === selectedLocale}>
 *                     {locale}
 *                 </option>
 *             ))}
 *        </select>
 *     );
 * }
 *
 * @param props The component props
 * @param {string} props.defaultLocale The locale selected by default. Default to 'en'.
 * @param {string[]} props.locales An array of the possible locales. For example: `['en', 'fr'].
 * @param {ReactElement} props.selector The element responsible for selecting a locale. Defaults to Material UI tabs.
 */
export var TranslatableInputs = function (inProps) {
    var _a;
    var props = useThemeProps({
        props: inProps,
        name: 'RaTranslatableInputs',
    });
    var className = props.className, defaultLocale = props.defaultLocale, fullWidth = props.fullWidth, locales = props.locales, _b = props.groupKey, groupKey = _b === void 0 ? '' : _b, _c = props.selector, selector = _c === void 0 ? React.createElement(TranslatableInputsTabs, { groupKey: groupKey }) : _c, children = props.children, margin = props.margin, sx = props.sx, _d = props.StackProps, StackProps = _d === void 0 ? {} : _d;
    var context = useTranslatable({ defaultLocale: defaultLocale, locales: locales });
    return (React.createElement(Root, { className: clsx(className, TranslatableInputsClasses.root, (_a = {},
            _a[TranslatableInputsClasses.fullWidth] = fullWidth,
            _a)), sx: sx },
        React.createElement(TranslatableContextProvider, { value: context },
            selector,
            locales.map(function (locale) { return (React.createElement(TranslatableInputsTabContent, __assign({ key: locale, locale: locale, groupKey: groupKey, margin: margin }, StackProps), children)); }))));
};
var PREFIX = 'RaTranslatableInputs';
export var TranslatableInputsClasses = {
    root: "".concat(PREFIX, "-root"),
    fullWidth: "".concat(PREFIX, "-fullWidth"),
};
var Root = styled('div', {
    name: PREFIX,
    overridesResolver: function (props, styles) { return styles.root; },
})(function (_a) {
    var _b;
    var theme = _a.theme;
    return (_b = {
            flexGrow: 1,
            marginTop: theme.spacing(1),
            marginBottom: theme.spacing(0.5)
        },
        _b["&.".concat(TranslatableInputsClasses.fullWidth)] = {
            width: '100%',
        },
        _b);
});
//# sourceMappingURL=TranslatableInputs.js.map