import { ReactElement, ReactNode } from 'react';
import { StackProps } from '@mui/material';
import { RaRecord } from 'ra-core';
/**
 * Default container for a group of translatable inputs inside a TranslatableInputs component.
 * @see TranslatableInputs
 */
export declare const TranslatableInputsTabContent: (props: TranslatableInputsTabContentProps) => ReactElement;
export type TranslatableInputsTabContentProps<RecordType extends RaRecord | Omit<RaRecord, 'id'> = any> = StackProps & {
    children: ReactNode;
    groupKey?: string;
    locale: string;
    record?: RecordType;
    resource?: string;
};
export declare const TranslatableInputsTabContentClasses: {
    root: string;
    hidden: string;
};
//# sourceMappingURL=TranslatableInputsTabContent.d.ts.map