var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
import * as React from 'react';
import { styled } from '@mui/material/styles';
import { AppBar, Tabs } from '@mui/material';
import { useTranslatableContext } from 'ra-core';
import { TranslatableInputsTab } from './TranslatableInputsTab';
/**
 * Default locale selector for the TranslatableInputs component. Generates a tab for each specified locale.
 * @see TranslatableInputs
 */
export var TranslatableInputsTabs = function (props) {
    var groupKey = props.groupKey, tabsProps = props.TabsProps;
    var _a = useTranslatableContext(), locales = _a.locales, selectLocale = _a.selectLocale, selectedLocale = _a.selectedLocale;
    var handleChange = function (event, newLocale) {
        selectLocale(newLocale);
    };
    return (React.createElement(StyledAppBar, { color: "default", position: "static", className: TranslatableInputsTabsClasses.root },
        React.createElement(Tabs, __assign({ value: selectedLocale, onChange: handleChange, indicatorColor: "primary", textColor: "primary", className: TranslatableInputsTabsClasses.tabs }, tabsProps), locales.map(function (locale) { return (React.createElement(TranslatableInputsTab, { key: locale, value: locale, locale: locale, groupKey: groupKey })); }))));
};
var PREFIX = 'RaTranslatableInputsTabs';
export var TranslatableInputsTabsClasses = {
    root: "".concat(PREFIX, "-root"),
    tabs: "".concat(PREFIX, "-tabs"),
};
var StyledAppBar = styled(AppBar, { name: PREFIX })(function (_a) {
    var _b;
    var theme = _a.theme;
    return (_b = {},
        _b["&.".concat(TranslatableInputsTabsClasses.root)] = {
            boxShadow: 'none',
            borderRadius: 0,
            borderTopLeftRadius: theme.shape.borderRadius,
            borderTopRightRadius: theme.shape.borderRadius,
            border: "1px solid ".concat(theme.palette.divider),
        },
        _b["& .".concat(TranslatableInputsTabsClasses.tabs)] = {
            minHeight: theme.spacing(3),
        },
        _b);
});
//# sourceMappingURL=TranslatableInputsTabs.js.map