var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
var __rest = (this && this.__rest) || function (s, e) {
    var t = {};
    for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p) && e.indexOf(p) < 0)
        t[p] = s[p];
    if (s != null && typeof Object.getOwnPropertySymbols === "function")
        for (var i = 0, p = Object.getOwnPropertySymbols(s); i < p.length; i++) {
            if (e.indexOf(p[i]) < 0 && Object.prototype.propertyIsEnumerable.call(s, p[i]))
                t[p[i]] = s[p[i]];
        }
    return t;
};
var _a;
import * as React from 'react';
import { styled } from '@mui/material/styles';
import { Typography } from '@mui/material';
import WarningAmber from '@mui/icons-material/WarningAmber';
import clsx from 'clsx';
import { useDefaultTitle, useTranslate } from 'ra-core';
import { Title } from './Title';
export var AuthenticationError = function (props) {
    var className = props.className, _a = props.icon, icon = _a === void 0 ? DEFAULT_ICON : _a, _b = props.textPrimary, textPrimary = _b === void 0 ? 'ra.page.authentication_error' : _b, _c = props.textSecondary, textSecondary = _c === void 0 ? 'ra.message.authentication_error' : _c, rest = __rest(props, ["className", "icon", "textPrimary", "textSecondary"]);
    var translate = useTranslate();
    var title = useDefaultTitle();
    return (React.createElement(Root, __assign({ className: clsx(AuthenticationErrorClasses.root, className) }, rest),
        React.createElement(Title, { defaultTitle: title }),
        React.createElement("div", { className: AuthenticationErrorClasses.message },
            icon,
            React.createElement(Typography, { variant: "h5", mt: 3, color: "text.secondary" }, translate(textPrimary, { _: textPrimary })),
            React.createElement(Typography, { variant: "body2" }, translate(textSecondary, { _: textSecondary })))));
};
var PREFIX = 'RaAuthenticationError';
export var AuthenticationErrorClasses = {
    root: "".concat(PREFIX, "-root"),
    icon: "".concat(PREFIX, "-icon"),
    message: "".concat(PREFIX, "-message"),
};
var Root = styled('div', {
    name: PREFIX,
    overridesResolver: function (props, styles) { return styles.root; },
})((_a = {
        display: 'flex',
        flexDirection: 'column',
        justifyContent: 'center',
        alignItems: 'center',
        height: '100%'
    },
    _a["& .".concat(AuthenticationErrorClasses.message)] = {
        textAlign: 'center',
        paddingTop: '1em',
        paddingBottom: '1em',
        opacity: 0.5,
    },
    _a["& .".concat(AuthenticationErrorClasses.icon)] = {
        width: '9em',
        height: '9em',
    },
    _a));
var DEFAULT_ICON = (React.createElement(WarningAmber, { className: AuthenticationErrorClasses.icon }));
//# sourceMappingURL=AuthenticationError.js.map