var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
var __rest = (this && this.__rest) || function (s, e) {
    var t = {};
    for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p) && e.indexOf(p) < 0)
        t[p] = s[p];
    if (s != null && typeof Object.getOwnPropertySymbols === "function")
        for (var i = 0, p = Object.getOwnPropertySymbols(s); i < p.length; i++) {
            if (e.indexOf(p[i]) < 0 && Object.prototype.propertyIsEnumerable.call(s, p[i]))
                t[p[i]] = s[p[i]];
        }
    return t;
};
import * as React from 'react';
import { Fragment } from 'react';
import { styled } from '@mui/material/styles';
import { Button, Accordion, AccordionDetails, AccordionSummary, Typography, } from '@mui/material';
import ErrorIcon from '@mui/icons-material/Report';
import ExpandMoreIcon from '@mui/icons-material/ExpandMore';
import History from '@mui/icons-material/History';
import { useTranslate, useDefaultTitle, useResetErrorBoundaryOnLocationChange, } from 'ra-core';
import { Title } from './Title';
export var Error = function (props) {
    var error = props.error, ErrorComponent = props.errorComponent, errorInfo = props.errorInfo, resetErrorBoundary = props.resetErrorBoundary, className = props.className, rest = __rest(props, ["error", "errorComponent", "errorInfo", "resetErrorBoundary", "className"]);
    var translate = useTranslate();
    var title = useDefaultTitle();
    useResetErrorBoundaryOnLocationChange(resetErrorBoundary);
    if (ErrorComponent) {
        return (React.createElement(ErrorComponent, { error: error, errorInfo: errorInfo, title: title }));
    }
    return (React.createElement(Fragment, null,
        title && React.createElement(Title, { title: title }),
        React.createElement(Root, __assign({ className: className }, rest),
            React.createElement("h1", { className: ErrorClasses.title, role: "alert" },
                React.createElement(ErrorIcon, { className: ErrorClasses.icon }),
                translate('ra.page.error')),
            React.createElement("div", null, translate('ra.message.error')),
            process.env.NODE_ENV !== 'production' && (React.createElement(React.Fragment, null,
                React.createElement(Accordion, { className: ErrorClasses.panel },
                    React.createElement(AccordionSummary, { expandIcon: React.createElement(ExpandMoreIcon, null), className: ErrorClasses.panelSumary }, translate(error.message, {
                        _: error.message,
                    })),
                    React.createElement(AccordionDetails, { className: ErrorClasses.panelDetails },
                        React.createElement("p", null, translate(error.message, {
                            _: error.message,
                        })),
                        React.createElement("p", null, errorInfo === null || errorInfo === void 0 ? void 0 : errorInfo.componentStack))),
                React.createElement("div", { className: ErrorClasses.advice },
                    React.createElement(Typography, { align: "center" }, "Need help with this error? Try the following:"),
                    React.createElement(Typography, { component: "div" },
                        React.createElement("ul", null,
                            React.createElement("li", null,
                                "Check the",
                                ' ',
                                React.createElement("a", { href: "https://marmelab.com/react-admin/documentation.html" }, "react-admin documentation")),
                            React.createElement("li", null,
                                "Search on",
                                ' ',
                                React.createElement("a", { href: "https://stackoverflow.com/questions/tagged/react-admin" }, "StackOverflow"),
                                ' ',
                                "for community answers"),
                            React.createElement("li", null,
                                "Get help from the core team via",
                                ' ',
                                React.createElement("a", { href: "https://react-admin-ee.marmelab.com/#fromsww" }, "react-admin Enterprise Edition"))))))),
            React.createElement("div", { className: ErrorClasses.toolbar },
                React.createElement(Button, { variant: "contained", startIcon: React.createElement(History, null), onClick: goBack }, translate('ra.action.back'))))));
};
var PREFIX = 'RaError';
export var ErrorClasses = {
    container: "".concat(PREFIX, "-container"),
    title: "".concat(PREFIX, "-title"),
    icon: "".concat(PREFIX, "-icon"),
    panel: "".concat(PREFIX, "-panel"),
    panelSumary: "".concat(PREFIX, "-panelSumary"),
    panelDetails: "".concat(PREFIX, "-panelDetails"),
    toolbar: "".concat(PREFIX, "-toolbar"),
    advice: "".concat(PREFIX, "-advice"),
};
var Root = styled('div', {
    name: PREFIX,
    overridesResolver: function (props, styles) { return styles.root; },
})(function (_a) {
    var _b;
    var theme = _a.theme;
    return (_b = {
            display: 'flex',
            flexDirection: 'column',
            alignItems: 'center',
            justifyContent: 'center'
        },
        _b[theme.breakpoints.down('md')] = {
            padding: '1em',
        },
        _b.fontFamily = 'Roboto, sans-serif',
        _b.opacity = 0.5,
        _b["& .".concat(ErrorClasses.title)] = {
            display: 'flex',
            alignItems: 'center',
        },
        _b["& .".concat(ErrorClasses.icon)] = {
            width: '2em',
            height: '2em',
            marginRight: '0.5em',
        },
        _b["& .".concat(ErrorClasses.panel)] = {
            marginTop: '1em',
            maxWidth: '60em',
        },
        _b["& .".concat(ErrorClasses.panelSumary)] = {
            userSelect: 'all',
        },
        _b["& .".concat(ErrorClasses.panelDetails)] = {
            whiteSpace: 'pre-wrap',
        },
        _b["& .".concat(ErrorClasses.toolbar)] = {
            marginTop: '2em',
        },
        _b["& .".concat(ErrorClasses.advice)] = {
            marginTop: '2em',
        },
        _b);
});
function goBack() {
    window.history.go(-1);
}
//# sourceMappingURL=Error.js.map