var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
var __rest = (this && this.__rest) || function (s, e) {
    var t = {};
    for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p) && e.indexOf(p) < 0)
        t[p] = s[p];
    if (s != null && typeof Object.getOwnPropertySymbols === "function")
        for (var i = 0, p = Object.getOwnPropertySymbols(s); i < p.length; i++) {
            if (e.indexOf(p[i]) < 0 && Object.prototype.propertyIsEnumerable.call(s, p[i]))
                t[p[i]] = s[p[i]];
        }
    return t;
};
import React, { Suspense, useState } from 'react';
import { ErrorBoundary } from 'react-error-boundary';
import clsx from 'clsx';
import { styled } from '@mui/material/styles';
import { AppBar as DefaultAppBar } from './AppBar';
import { Sidebar as DefaultSidebar } from './Sidebar';
import { Menu as DefaultMenu } from './Menu';
import { Error } from './Error';
import { SkipNavigationButton } from '../button';
import { Inspector } from '../preferences';
import { Loading } from './Loading';
export var Layout = function (props) {
    var _a = props.appBar, AppBar = _a === void 0 ? DefaultAppBar : _a, appBarAlwaysOn = props.appBarAlwaysOn, children = props.children, className = props.className, errorComponent = props.error, _b = props.menu, Menu = _b === void 0 ? DefaultMenu : _b, _c = props.sidebar, Sidebar = _c === void 0 ? DefaultSidebar : _c, rest = __rest(props, ["appBar", "appBarAlwaysOn", "children", "className", "error", "menu", "sidebar"]);
    var _d = useState(undefined), errorInfo = _d[0], setErrorInfo = _d[1];
    var handleError = function (error, info) {
        setErrorInfo(info);
    };
    return (React.createElement(Core, __assign({ className: clsx('layout', className) }, rest),
        React.createElement(SkipNavigationButton, null),
        React.createElement("div", { className: LayoutClasses.appFrame },
            React.createElement(AppBar, { alwaysOn: appBarAlwaysOn }),
            React.createElement("main", { className: LayoutClasses.contentWithSidebar },
                React.createElement(Sidebar, { appBarAlwaysOn: appBarAlwaysOn },
                    React.createElement(Menu, null)),
                React.createElement("div", { id: "main-content", className: LayoutClasses.content },
                    React.createElement(ErrorBoundary, { onError: handleError, fallbackRender: function (_a) {
                            var error = _a.error, resetErrorBoundary = _a.resetErrorBoundary;
                            return (React.createElement(Error, { error: error, errorComponent: errorComponent, errorInfo: errorInfo, resetErrorBoundary: resetErrorBoundary }));
                        } },
                        React.createElement(Suspense, { fallback: React.createElement(Loading, null) }, children)))),
            React.createElement(Inspector, null))));
};
var PREFIX = 'RaLayout';
export var LayoutClasses = {
    appFrame: "".concat(PREFIX, "-appFrame"),
    contentWithSidebar: "".concat(PREFIX, "-contentWithSidebar"),
    content: "".concat(PREFIX, "-content"),
};
var Core = styled('div', {
    name: PREFIX,
    overridesResolver: function (props, styles) { return styles.root; },
})(function (_a) {
    var _b, _c, _d;
    var theme = _a.theme;
    return (_b = {
            display: 'flex',
            flexDirection: 'column',
            zIndex: 1,
            minHeight: '100vh',
            backgroundColor: theme.palette.background.default,
            position: 'relative',
            minWidth: 'fit-content',
            width: '100%',
            color: theme.palette.getContrastText(theme.palette.background.default)
        },
        _b["& .".concat(LayoutClasses.appFrame)] = (_c = {
                display: 'flex',
                flexDirection: 'column',
                flexGrow: 1,
                marginTop: theme.spacing(6)
            },
            _c[theme.breakpoints.down('sm')] = {
                marginTop: theme.spacing(7),
            },
            _c),
        _b["& .".concat(LayoutClasses.contentWithSidebar)] = {
            display: 'flex',
            flexGrow: 1,
            transition: theme.transitions.create('margin', {
                easing: theme.transitions.easing.easeOut,
                duration: theme.transitions.duration.enteringScreen,
            }),
        },
        _b["& .".concat(LayoutClasses.content)] = (_d = {
                backgroundColor: theme.palette.background.default,
                zIndex: 2,
                display: 'flex',
                flexDirection: 'column',
                flexGrow: 1,
                flexBasis: 0,
                padding: 0
            },
            _d[theme.breakpoints.up('xs')] = {
                paddingRight: theme.spacing(1),
                paddingLeft: theme.spacing(1),
            },
            _d),
        _b);
});
//# sourceMappingURL=Layout.js.map