var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
var __rest = (this && this.__rest) || function (s, e) {
    var t = {};
    for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p) && e.indexOf(p) < 0)
        t[p] = s[p];
    if (s != null && typeof Object.getOwnPropertySymbols === "function")
        for (var i = 0, p = Object.getOwnPropertySymbols(s); i < p.length; i++) {
            if (e.indexOf(p[i]) < 0 && Object.prototype.propertyIsEnumerable.call(s, p[i]))
                t[p[i]] = s[p[i]];
        }
    return t;
};
var _a, _b;
import * as React from 'react';
import { styled } from '@mui/material/styles';
import clsx from 'clsx';
import { useTheme } from '@mui/material/styles';
import CircularProgress from '@mui/material/CircularProgress';
import { useLoading } from 'ra-core';
import { RefreshIconButton } from '../button';
export var LoadingIndicator = function (props) {
    var className = props.className, onClick = props.onClick, sx = props.sx, rest = __rest(props, ["className", "onClick", "sx"]);
    var loading = useLoading();
    var theme = useTheme();
    return (React.createElement(Root, { className: className, sx: sx },
        React.createElement(RefreshIconButton, { className: "".concat(LoadingIndicatorClasses.loadedIcon, " ").concat(loading && LoadingIndicatorClasses.loadedLoading), onClick: onClick }),
        loading && (React.createElement(CircularProgress, __assign({ className: clsx('app-loader', LoadingIndicatorClasses.loader), color: "inherit", size: theme.spacing(2), thickness: 6 }, rest)))));
};
var PREFIX = 'RaLoadingIndicator';
export var LoadingIndicatorClasses = {
    loader: "".concat(PREFIX, "-loader"),
    loadedLoading: "".concat(PREFIX, "-loadedLoading"),
    loadedIcon: "".concat(PREFIX, "-loadedIcon"),
};
var Root = styled('div', {
    name: PREFIX,
    overridesResolver: function (_, styles) { return styles.root; },
})((_a = {
        position: 'relative'
    },
    _a["& .".concat(LoadingIndicatorClasses.loadedIcon)] = (_b = {},
        _b["&.".concat(LoadingIndicatorClasses.loadedLoading)] = {
            opacity: 0,
        },
        _b),
    _a["& .".concat(LoadingIndicatorClasses.loader)] = {
        position: 'absolute',
        top: '30%',
        left: '30%',
    },
    _a));
//# sourceMappingURL=LoadingIndicator.js.map