var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
var __rest = (this && this.__rest) || function (s, e) {
    var t = {};
    for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p) && e.indexOf(p) < 0)
        t[p] = s[p];
    if (s != null && typeof Object.getOwnPropertySymbols === "function")
        for (var i = 0, p = Object.getOwnPropertySymbols(s); i < p.length; i++) {
            if (e.indexOf(p[i]) < 0 && Object.prototype.propertyIsEnumerable.call(s, p[i]))
                t[p[i]] = s[p[i]];
        }
    return t;
};
import * as React from 'react';
import { MenuList } from '@mui/material';
import { styled } from '@mui/material/styles';
import lodashGet from 'lodash/get';
import clsx from 'clsx';
import { DRAWER_WIDTH, CLOSED_DRAWER_WIDTH } from './Sidebar';
import { useSidebarState } from './useSidebarState';
import { DashboardMenuItem } from './DashboardMenuItem';
import { MenuItemLink } from './MenuItemLink';
import { ResourceMenuItem } from './ResourceMenuItem';
import { ResourceMenuItems } from './ResourceMenuItems';
import { useHasDashboard } from 'ra-core';
/**
 * Renders a menu with one menu item per resource by default. You can also set menu items by hand.
 *
 * @example
 * import * as React from 'react';
 * import { Menu } from 'react-admin';
 *
 * import BookIcon from '@mui/icons-material/Book';
 * import ChatBubbleIcon from '@mui/icons-material/ChatBubble';
 * import PeopleIcon from '@mui/icons-material/People';
 * import LabelIcon from '@mui/icons-material/Label';
 *
 * export const MyMenu = () => (
 *     <Menu>
 *         <Menu.DashboardItem />
 *         <Menu.Item to="/posts" primaryText="Posts" leftIcon={<BookIcon />}/>
 *         <Menu.Item to="/comments" primaryText="Comments" leftIcon={<ChatBubbleIcon />}/>
 *         <Menu.Item to="/users" primaryText="Users" leftIcon={<PeopleIcon />}/>
 *         <Menu.Item to="/custom-route" primaryText="Miscellaneous" leftIcon={<LabelIcon />}/>
 *     </Menu>
 * );
 */
export var Menu = function (props) {
    var _a;
    var children = props.children, className = props.className, rest = __rest(props, ["children", "className"]);
    var hasDashboard = useHasDashboard();
    var open = useSidebarState()[0];
    return (React.createElement(Root, __assign({ className: clsx((_a = {},
            _a[MenuClasses.open] = open,
            _a[MenuClasses.closed] = !open,
            _a), className) }, rest),
        hasDashboard && !children && React.createElement(DashboardMenuItem, null), children !== null && children !== void 0 ? children : React.createElement(ResourceMenuItems, null)));
};
// re-export MenuItem components for convenience
Menu.Item = MenuItemLink;
Menu.DashboardItem = DashboardMenuItem;
Menu.ResourceItem = ResourceMenuItem;
Menu.ResourceItems = ResourceMenuItems;
var PREFIX = 'RaMenu';
export var MenuClasses = {
    open: "".concat(PREFIX, "-open"),
    closed: "".concat(PREFIX, "-closed"),
};
var Root = styled(MenuList, {
    name: PREFIX,
    overridesResolver: function (props, styles) { return styles.root; },
})(function (_a) {
    var _b;
    var theme = _a.theme;
    return (_b = {
            display: 'flex',
            flexDirection: 'column',
            justifyContent: 'flex-start'
        },
        _b[theme.breakpoints.only('xs')] = {
            marginTop: 0,
        },
        _b.transition = theme.transitions.create('width', {
            easing: theme.transitions.easing.sharp,
            duration: theme.transitions.duration.leavingScreen,
        }),
        _b["&.".concat(MenuClasses.open)] = {
            width: lodashGet(theme, 'sidebar.width', DRAWER_WIDTH),
        },
        _b["&.".concat(MenuClasses.closed)] = {
            width: lodashGet(theme, 'sidebar.closedWidth', CLOSED_DRAWER_WIDTH),
        },
        _b);
});
//# sourceMappingURL=Menu.js.map