var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
var __rest = (this && this.__rest) || function (s, e) {
    var t = {};
    for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p) && e.indexOf(p) < 0)
        t[p] = s[p];
    if (s != null && typeof Object.getOwnPropertySymbols === "function")
        for (var i = 0, p = Object.getOwnPropertySymbols(s); i < p.length; i++) {
            if (e.indexOf(p[i]) < 0 && Object.prototype.propertyIsEnumerable.call(s, p[i]))
                t[p[i]] = s[p[i]];
        }
    return t;
};
import * as React from 'react';
import { styled } from '@mui/material/styles';
import Button from '@mui/material/Button';
import HotTub from '@mui/icons-material/HotTub';
import History from '@mui/icons-material/History';
import { useAuthenticated, useDefaultTitle, useTranslate } from 'ra-core';
import { Title } from './Title';
import { Loading } from './Loading';
export var NotFound = function (props) {
    var className = props.className, rest = __rest(props, ["className"]);
    var translate = useTranslate();
    var isPending = useAuthenticated().isPending;
    var title = useDefaultTitle();
    if (isPending)
        return React.createElement(Loading, null);
    return (React.createElement(Root, __assign({ className: className }, sanitizeRestProps(rest)),
        React.createElement(Title, { defaultTitle: title }),
        React.createElement("div", { className: NotFoundClasses.message },
            React.createElement(HotTub, { className: NotFoundClasses.icon }),
            React.createElement("h1", null, translate('ra.page.not_found')),
            React.createElement("div", null,
                translate('ra.message.not_found'),
                ".")),
        React.createElement("div", { className: NotFoundClasses.toolbar },
            React.createElement(Button, { variant: "contained", startIcon: React.createElement(History, null), onClick: goBack }, translate('ra.action.back')))));
};
var sanitizeRestProps = function (_a) {
    var staticContext = _a.staticContext, history = _a.history, location = _a.location, match = _a.match, rest = __rest(_a, ["staticContext", "history", "location", "match"]);
    return rest;
};
var PREFIX = 'RaNotFound';
export var NotFoundClasses = {
    icon: "".concat(PREFIX, "-icon"),
    message: "".concat(PREFIX, "-message"),
    toolbar: "".concat(PREFIX, "-toolbar"),
};
var Root = styled('div', {
    name: PREFIX,
    overridesResolver: function (props, styles) { return styles.root; },
})(function (_a) {
    var _b;
    var theme = _a.theme;
    return (_b = {
            display: 'flex',
            flexDirection: 'column',
            justifyContent: 'center'
        },
        _b[theme.breakpoints.up('md')] = {
            height: '100%',
        },
        _b[theme.breakpoints.down('md')] = {
            height: '100vh',
            marginTop: '-3em',
        },
        _b["& .".concat(NotFoundClasses.icon)] = {
            width: '9em',
            height: '9em',
        },
        _b["& .".concat(NotFoundClasses.message)] = {
            textAlign: 'center',
            fontFamily: 'Roboto, sans-serif',
            opacity: 0.5,
            margin: '0 1em',
        },
        _b["& .".concat(NotFoundClasses.toolbar)] = {
            textAlign: 'center',
            marginTop: '2em',
        },
        _b);
});
function goBack() {
    window.history.go(-1);
}
//# sourceMappingURL=NotFound.js.map