var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
var __rest = (this && this.__rest) || function (s, e) {
    var t = {};
    for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p) && e.indexOf(p) < 0)
        t[p] = s[p];
    if (s != null && typeof Object.getOwnPropertySymbols === "function")
        for (var i = 0, p = Object.getOwnPropertySymbols(s); i < p.length; i++) {
            if (e.indexOf(p[i]) < 0 && Object.prototype.propertyIsEnumerable.call(s, p[i]))
                t[p[i]] = s[p[i]];
        }
    return t;
};
import * as React from 'react';
import { styled } from '@mui/material/styles';
import { Drawer, useMediaQuery, useScrollTrigger, } from '@mui/material';
import lodashGet from 'lodash/get';
import { useLocale } from 'ra-core';
import { useSidebarState } from './useSidebarState';
export var Sidebar = function (props) {
    var appBarAlwaysOn = props.appBarAlwaysOn, children = props.children, closedSize = props.closedSize, size = props.size, rest = __rest(props, ["appBarAlwaysOn", "children", "closedSize", "size"]);
    var isXSmall = useMediaQuery(function (theme) {
        return theme.breakpoints.down('sm');
    });
    var _a = useSidebarState(), open = _a[0], setOpen = _a[1];
    useLocale(); // force redraw on locale change
    var trigger = useScrollTrigger();
    var toggleSidebar = function () { return setOpen(!open); };
    return isXSmall ? (React.createElement(StyledDrawer, __assign({ variant: "temporary", open: open, onClose: toggleSidebar, classes: SidebarClasses }, rest), children)) : (React.createElement(StyledDrawer, __assign({ variant: "permanent", open: open, onClose: toggleSidebar, classes: SidebarClasses, className: trigger && !appBarAlwaysOn ? SidebarClasses.appBarCollapsed : '' }, rest),
        React.createElement("div", { className: SidebarClasses.fixed }, children)));
};
var PREFIX = 'RaSidebar';
export var SidebarClasses = {
    docked: "".concat(PREFIX, "-docked"),
    paper: "".concat(PREFIX, "-paper"),
    paperAnchorLeft: "".concat(PREFIX, "-paperAnchorLeft"),
    paperAnchorRight: "".concat(PREFIX, "-paperAnchorRight"),
    paperAnchorTop: "".concat(PREFIX, "-paperAnchorTop"),
    paperAnchorBottom: "".concat(PREFIX, "-paperAnchorBottom"),
    paperAnchorDockedLeft: "".concat(PREFIX, "-paperAnchorDockedLeft"),
    paperAnchorDockedTop: "".concat(PREFIX, "-paperAnchorDockedTop"),
    paperAnchorDockedRight: "".concat(PREFIX, "-paperAnchorDockedRight"),
    paperAnchorDockedBottom: "".concat(PREFIX, "-paperAnchorDockedBottom"),
    modal: "".concat(PREFIX, "-modal"),
    fixed: "".concat(PREFIX, "-fixed"),
    appBarCollapsed: "".concat(PREFIX, "-appBarCollapsed"),
};
var StyledDrawer = styled(Drawer, {
    name: PREFIX,
    slot: 'Root',
    overridesResolver: function (props, styles) { return styles.root; },
    shouldForwardProp: function () { return true; },
})(function (_a) {
    var _b, _c, _d;
    var open = _a.open, theme = _a.theme;
    return (_b = {
            height: 'calc(100vh - 3em)',
            marginTop: 0,
            transition: theme.transitions.create('margin', {
                easing: theme.transitions.easing.easeOut,
                duration: theme.transitions.duration.enteringScreen,
            })
        },
        _b["&.".concat(SidebarClasses.appBarCollapsed)] = (_c = {
                // compensate the margin of the Layout appFrame instead of removing it in the Layout
                // because otherwise, the appFrame content without margin may revert the scrollTrigger,
                // leading to a visual jiggle
                marginTop: theme.spacing(-6)
            },
            _c[theme.breakpoints.down('sm')] = {
                marginTop: theme.spacing(-7),
            },
            _c.transition = theme.transitions.create('margin', {
                easing: theme.transitions.easing.sharp,
                duration: theme.transitions.duration.leavingScreen,
            }),
            _c),
        _b["& .".concat(SidebarClasses.docked)] = {},
        _b["& .".concat(SidebarClasses.paper)] = {},
        _b["& .".concat(SidebarClasses.paperAnchorLeft)] = {},
        _b["& .".concat(SidebarClasses.paperAnchorRight)] = {},
        _b["& .".concat(SidebarClasses.paperAnchorTop)] = {},
        _b["& .".concat(SidebarClasses.paperAnchorBottom)] = {},
        _b["& .".concat(SidebarClasses.paperAnchorDockedLeft)] = {},
        _b["& .".concat(SidebarClasses.paperAnchorDockedTop)] = {},
        _b["& .".concat(SidebarClasses.paperAnchorDockedRight)] = {},
        _b["& .".concat(SidebarClasses.paperAnchorDockedBottom)] = {},
        _b["& .".concat(SidebarClasses.modal)] = {},
        _b["& .".concat(SidebarClasses.fixed)] = {
            position: 'fixed',
            height: 'calc(100vh - 3em)',
            overflowX: 'hidden',
            // hide scrollbar
            scrollbarWidth: 'none',
            msOverflowStyle: 'none',
            '&::-webkit-scrollbar': {
                display: 'none',
            },
        },
        _b["& .MuiPaper-root"] = (_d = {
                position: 'relative',
                width: open
                    ? lodashGet(theme, 'sidebar.width', DRAWER_WIDTH)
                    : lodashGet(theme, 'sidebar.closedWidth', CLOSED_DRAWER_WIDTH),
                transition: theme.transitions.create('width', {
                    easing: theme.transitions.easing.sharp,
                    duration: theme.transitions.duration.leavingScreen,
                }),
                backgroundColor: 'transparent',
                borderRight: 'none'
            },
            _d[theme.breakpoints.only('xs')] = {
                marginTop: 0,
                height: '100vh',
                position: 'inherit',
                backgroundColor: theme.palette.background.default,
            },
            _d[theme.breakpoints.up('md')] = {
                border: 'none',
            },
            _d.zIndex = 'inherit',
            _d),
        _b);
});
export var DRAWER_WIDTH = 240;
export var CLOSED_DRAWER_WIDTH = 55;
//# sourceMappingURL=Sidebar.js.map