import * as React from 'react';
import { styled } from '@mui/material/styles';
import { IconButton, Tooltip } from '@mui/material';
import MenuIcon from '@mui/icons-material/Menu';
import { useTranslate } from 'ra-core';
import { useSidebarState } from './useSidebarState';
/**
 * A button that toggles the sidebar. Used by default in the <AppBar>.
 * @param props The component props
 * @param {String} props.className An optional class name to apply to the button
 */
export var SidebarToggleButton = function (props) {
    var translate = useTranslate();
    var className = props.className;
    var _a = useSidebarState(), open = _a[0], setOpen = _a[1];
    return (React.createElement(Tooltip, { className: className, title: translate(open ? 'ra.action.close_menu' : 'ra.action.open_menu', { _: 'Open/Close menu' }), enterDelay: 500 },
        React.createElement(StyledIconButton, { color: "inherit", onClick: function () { return setOpen(!open); } },
            React.createElement(MenuIcon, { classes: {
                    root: open
                        ? SidebarToggleButtonClasses.menuButtonIconOpen
                        : SidebarToggleButtonClasses.menuButtonIconClosed,
                } }))));
};
var PREFIX = 'RaSidebarToggleButton';
export var SidebarToggleButtonClasses = {
    menuButtonIconClosed: "".concat(PREFIX, "-menuButtonIconClosed"),
    menuButtonIconOpen: "".concat(PREFIX, "-menuButtonIconOpen"),
};
var StyledIconButton = styled(IconButton, {
    name: PREFIX,
    overridesResolver: function (props, styles) { return styles.root; },
})(function (_a) {
    var _b;
    var theme = _a.theme;
    return (_b = {},
        _b["& .".concat(SidebarToggleButtonClasses.menuButtonIconClosed)] = {
            transition: theme.transitions.create(['transform'], {
                easing: theme.transitions.easing.sharp,
                duration: theme.transitions.duration.leavingScreen,
            }),
            transform: 'rotate(0deg)',
        },
        _b["& .".concat(SidebarToggleButtonClasses.menuButtonIconOpen)] = {
            transition: theme.transitions.create(['transform'], {
                easing: theme.transitions.easing.sharp,
                duration: theme.transitions.duration.leavingScreen,
            }),
            transform: 'rotate(180deg)',
        },
        _b);
});
//# sourceMappingURL=SidebarToggleButton.js.map