var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
var __rest = (this && this.__rest) || function (s, e) {
    var t = {};
    for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p) && e.indexOf(p) < 0)
        t[p] = s[p];
    if (s != null && typeof Object.getOwnPropertySymbols === "function")
        for (var i = 0, p = Object.getOwnPropertySymbols(s); i < p.length; i++) {
            if (e.indexOf(p[i]) < 0 && Object.prototype.propertyIsEnumerable.call(s, p[i]))
                t[p[i]] = s[p[i]];
        }
    return t;
};
import * as React from 'react';
import { useResourceContext, useGetList, useTimeout, useCreatePath, } from 'ra-core';
import { Typography, CircularProgress } from '@mui/material';
import ErrorIcon from '@mui/icons-material/Error';
import { Link } from '../Link';
/**
 * Fetch and render the number of records of a given resource
 *
 * Relies on dataProvider.getList() returning a total property
 *
 * @example // Display the number of records in the current resource (based on ResourceContext)
 * <Count />
 *
 * @example // Display the number of posts
 * <Count resource="posts" />
 *
 * @example // Display the number of published posts
 * <Count resource="posts" filter={{ is_published: true }}/>
 *
 * @example // Display the number of posts, with a custom Typography variant
 * <Count resource="posts" variant="h1" />
 *
 * @see ReferenceManyCount for a similar component which fetches the number of records related to the current one
 */
export var Count = function (props) {
    var filter = props.filter, sort = props.sort, link = props.link, resourceFromProps = props.resource, _a = props.timeout, timeout = _a === void 0 ? 1000 : _a, rest = __rest(props, ["filter", "sort", "link", "resource", "timeout"]);
    var resource = useResourceContext(props);
    if (!resource) {
        throw new Error('The Count component must be used inside a ResourceContext or must be passed a resource prop.');
    }
    var oneSecondHasPassed = useTimeout(timeout);
    var createPath = useCreatePath();
    var _b = useGetList(resource, {
        filter: filter,
        sort: sort,
        pagination: { perPage: 1, page: 1 },
    }), total = _b.total, isPending = _b.isPending, error = _b.error;
    var body = isPending ? (oneSecondHasPassed ? (React.createElement(CircularProgress, { size: 14 })) : ('')) : error ? (React.createElement(ErrorIcon, { color: "error", fontSize: "small", titleAccess: "error" })) : (total);
    return link ? (
    // @ts-ignore TypeScript complains that the props for <a> aren't the same as for <span>
    React.createElement(Link, __assign({ to: {
            pathname: createPath({ resource: resource, type: 'list' }),
            search: filter ? "filter=".concat(JSON.stringify(filter)) : undefined,
        }, variant: "body2", onClick: function (e) { return e.stopPropagation(); } }, rest), body)) : (React.createElement(Typography, __assign({ component: "span", variant: "body2" }, rest), body));
};
//# sourceMappingURL=Count.js.map