import * as React from 'react';
import { styled } from '@mui/material/styles';
import { Typography } from '@mui/material';
import Inbox from '@mui/icons-material/Inbox';
import { useTranslate, useResourceDefinition, useResourceContext, useGetResourceLabel, } from 'ra-core';
import { CreateButton } from '../button';
export var Empty = function (props) {
    var className = props.className;
    var hasCreate = useResourceDefinition(props).hasCreate;
    var resource = useResourceContext(props);
    var translate = useTranslate();
    var getResourceLabel = useGetResourceLabel();
    var resourceName = translate("resources.".concat(resource, ".forcedCaseName"), {
        smart_count: 0,
        _: resource ? getResourceLabel(resource, 0) : undefined,
    });
    var emptyMessage = translate('ra.page.empty', { name: resourceName });
    var inviteMessage = translate('ra.page.invite');
    return (React.createElement(Root, { className: className },
        React.createElement("div", { className: EmptyClasses.message },
            React.createElement(Inbox, { className: EmptyClasses.icon }),
            React.createElement(Typography, { variant: "h4", paragraph: true }, translate("resources.".concat(resource, ".empty"), {
                _: emptyMessage,
            })),
            hasCreate && (React.createElement(Typography, { variant: "body1" }, translate("resources.".concat(resource, ".invite"), {
                _: inviteMessage,
            })))),
        hasCreate && (React.createElement("div", { className: EmptyClasses.toolbar },
            React.createElement(CreateButton, { variant: "contained" })))));
};
var PREFIX = 'RaEmpty';
export var EmptyClasses = {
    message: "".concat(PREFIX, "-message"),
    icon: "".concat(PREFIX, "-icon"),
    toolbar: "".concat(PREFIX, "-toolbar"),
};
var Root = styled('span', {
    name: PREFIX,
    overridesResolver: function (props, styles) { return styles.root; },
})(function (_a) {
    var _b;
    var theme = _a.theme;
    return (_b = {
            flex: 1
        },
        _b["& .".concat(EmptyClasses.message)] = {
            textAlign: 'center',
            opacity: theme.palette.mode === 'light' ? 0.5 : 0.8,
            margin: '0 1em',
            color: theme.palette.mode === 'light'
                ? 'inherit'
                : theme.palette.text.primary,
        },
        _b["& .".concat(EmptyClasses.icon)] = {
            width: '9em',
            height: '9em',
        },
        _b["& .".concat(EmptyClasses.toolbar)] = {
            textAlign: 'center',
            marginTop: '2em',
        },
        _b);
});
//# sourceMappingURL=Empty.js.map