var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
var __rest = (this && this.__rest) || function (s, e) {
    var t = {};
    for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p) && e.indexOf(p) < 0)
        t[p] = s[p];
    if (s != null && typeof Object.getOwnPropertySymbols === "function")
        for (var i = 0, p = Object.getOwnPropertySymbols(s); i < p.length; i++) {
            if (e.indexOf(p[i]) < 0 && Object.prototype.propertyIsEnumerable.call(s, p[i]))
                t[p[i]] = s[p[i]];
        }
    return t;
};
import * as React from 'react';
import { InfiniteListBase } from 'ra-core';
import { InfinitePagination } from './pagination';
import { ListView } from './ListView';
import { Loading } from '../layout';
/**
 * Infinite List page component
 *
 * The <InfiniteList> component renders the list layout (title, buttons, filters),
 * and fetches the list of records from the REST API.
 *
 * It then delegates the rendering of the list of records to its child component.
 * Usually, it's a <Datagrid>, responsible for displaying a table with one row for each post.
 *
 * It contains an <InfinitePagination> component, which fetches the next page of records
 * when the user scrolls to the bottom of the list.
 *
 * The <InfiniteList> component accepts the following props:
 *
 * - actions
 * - aside: Side Component
 * - children: List Layout
 * - component
 * - disableAuthentication
 * - disableSyncWithLocation
 * - empty: Empty Page Component
 * - emptyWhileLoading
 * - exporter
 * - filters: Filter Inputs
 * - filter: Permanent Filter
 * - filterDefaultValues
 * - pagination: Pagination Component
 * - perPage: Pagination Size
 * - queryOptions
 * - sort: Default Sort Field & Order
 * - title
 * - sx: CSS API
 *
 * @example
 * const postFilters = [
 *     <TextInput label="Search" source="q" alwaysOn />,
 *     <TextInput label="Title" source="title" />
 * ];
 * export const PostList = () => (
 *     <InfiniteList
 *         title="List of posts"
 *         sort={{ field: 'published_at' }}
 *         filter={{ is_published: true }}
 *         filters={postFilters}
 *     >
 *         <Datagrid>
 *             <TextField source="id" />
 *             <TextField source="title" />
 *             <EditButton />
 *         </Datagrid>
 *     </List>
 * );
 */
export var InfiniteList = function (_a) {
    var debounce = _a.debounce, disableAuthentication = _a.disableAuthentication, disableSyncWithLocation = _a.disableSyncWithLocation, exporter = _a.exporter, _b = _a.filter, filter = _b === void 0 ? defaultFilter : _b, filterDefaultValues = _a.filterDefaultValues, _c = _a.loading, loading = _c === void 0 ? defaultLoading : _c, _d = _a.pagination, pagination = _d === void 0 ? defaultPagination : _d, _e = _a.perPage, perPage = _e === void 0 ? 10 : _e, queryOptions = _a.queryOptions, resource = _a.resource, sort = _a.sort, storeKey = _a.storeKey, rest = __rest(_a, ["debounce", "disableAuthentication", "disableSyncWithLocation", "exporter", "filter", "filterDefaultValues", "loading", "pagination", "perPage", "queryOptions", "resource", "sort", "storeKey"]);
    return (React.createElement(InfiniteListBase, { debounce: debounce, disableAuthentication: disableAuthentication, disableSyncWithLocation: disableSyncWithLocation, exporter: exporter, filter: filter, filterDefaultValues: filterDefaultValues, loading: loading, perPage: perPage, queryOptions: queryOptions, resource: resource, sort: sort, storeKey: storeKey },
        React.createElement(ListView, __assign({}, rest, { pagination: pagination }))));
};
var defaultPagination = React.createElement(InfinitePagination, null);
var defaultFilter = {};
var defaultLoading = React.createElement(Loading, null);
//# sourceMappingURL=InfiniteList.js.map