var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
var __rest = (this && this.__rest) || function (s, e) {
    var t = {};
    for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p) && e.indexOf(p) < 0)
        t[p] = s[p];
    if (s != null && typeof Object.getOwnPropertySymbols === "function")
        for (var i = 0, p = Object.getOwnPropertySymbols(s); i < p.length; i++) {
            if (e.indexOf(p[i]) < 0 && Object.prototype.propertyIsEnumerable.call(s, p[i]))
                t[p[i]] = s[p[i]];
        }
    return t;
};
import * as React from 'react';
import { useState, useEffect } from 'react';
import { ListBase, getElementsFromRecords, InferredElement, useListContext, useResourceContext, usePrevious, } from 'ra-core';
import { useLocation } from 'react-router';
import { ListView } from './ListView';
import { listFieldTypes } from './listFieldTypes';
import { capitalize, singularize } from 'inflection';
/**
 * List component rendering a <Datagrid> based on the result of the
 * dataProvider.getList() call.
 *
 * The result (choice and type of columns) isn't configurable, but the
 * <ListGuesser> outputs the <Datagrid> it has guessed to the console so that
 * developers can start from there.
 *
 * To be used as the list prop of a <Resource>.
 *
 * @example
 *
 * import { Admin, Resource, ListGuesser } from 'react-admin';
 *
 * const App = () => (
 *     <Admin dataProvider={myDataProvider}>
 *         <Resource name="posts" list={ListGuesser} />
 *     </Admin>
 * );
 */
export var ListGuesser = function (props) {
    var debounce = props.debounce, disableAuthentication = props.disableAuthentication, disableSyncWithLocation = props.disableSyncWithLocation, exporter = props.exporter, filter = props.filter, filterDefaultValues = props.filterDefaultValues, perPage = props.perPage, queryOptions = props.queryOptions, resource = props.resource, sort = props.sort, rest = __rest(props, ["debounce", "disableAuthentication", "disableSyncWithLocation", "exporter", "filter", "filterDefaultValues", "perPage", "queryOptions", "resource", "sort"]);
    // force a rerender of this component when any list parameter changes
    // otherwise the ListBase won't be rerendered when the sort changes
    // and the following check won't be performed
    useLocation();
    // keep previous data, unless the resource changes
    var resourceFromContext = useResourceContext(props);
    var previousResource = usePrevious(resourceFromContext);
    var keepPreviousData = previousResource === resourceFromContext;
    return (React.createElement(ListBase, { debounce: debounce, disableAuthentication: disableAuthentication, disableSyncWithLocation: disableSyncWithLocation, exporter: exporter, filter: filter, filterDefaultValues: filterDefaultValues, perPage: perPage, queryOptions: {
            placeholderData: function (previousData) {
                return keepPreviousData ? previousData : undefined;
            },
        }, resource: resource, sort: sort },
        React.createElement(ListViewGuesser, __assign({}, rest))));
};
var ListViewGuesser = function (props) {
    var data = useListContext().data;
    var resource = useResourceContext();
    var _a = useState(null), child = _a[0], setChild = _a[1];
    var _b = props.enableLog, enableLog = _b === void 0 ? process.env.NODE_ENV === 'development' : _b, rest = __rest(props, ["enableLog"]);
    useEffect(function () {
        setChild(null);
    }, [resource]);
    useEffect(function () {
        if (data && data.length > 0 && !child) {
            var inferredElements = getElementsFromRecords(data, listFieldTypes);
            var inferredChild = new InferredElement(listFieldTypes.table, null, inferredElements);
            var inferredChildElement = inferredChild.getElement();
            var representation = inferredChild.getRepresentation();
            if (!resource) {
                throw new Error('Cannot use <ListGuesser> outside of a ResourceContext');
            }
            if (!inferredChildElement || !representation) {
                return;
            }
            setChild(inferredChildElement);
            var components = ['List']
                .concat(Array.from(new Set(Array.from(representation.matchAll(/<([^/\s>]+)/g))
                .map(function (match) { return match[1]; })
                .filter(function (component) { return component !== 'span'; }))))
                .sort();
            if (enableLog) {
                // eslint-disable-next-line no-console
                console.log("Guessed List:\n\nimport { ".concat(components.join(', '), " } from 'react-admin';\n\nexport const ").concat(capitalize(singularize(resource)), "List = () => (\n    <List>\n").concat(inferredChild.getRepresentation(), "\n    </List>\n);"));
            }
        }
    }, [data, child, resource, enableLog]);
    return React.createElement(ListView, __assign({}, rest), child);
};
//# sourceMappingURL=ListGuesser.js.map