import * as React from 'react';
import { CardContent, Typography } from '@mui/material';
import { useListContext, useResourceContext, useTranslate } from 'ra-core';
import { Button } from '../button';
export var ListNoResults = function () {
    var translate = useTranslate();
    var resource = useResourceContext();
    var _a = useListContext(), filterValues = _a.filterValues, setFilters = _a.setFilters;
    return (React.createElement(CardContent, null,
        React.createElement(Typography, { variant: "body2" }, filterValues && Object.keys(filterValues).length > 0 ? (React.createElement(React.Fragment, null,
            translate('ra.navigation.no_filtered_results', {
                resource: resource,
                _: 'No results found with the current filters.',
            }),
            ' ',
            React.createElement(Button, { onClick: function () { return setFilters({}, []); }, label: translate('ra.navigation.clear_filters', {
                    _: 'Clear filters',
                }) }))) : (translate('ra.navigation.no_results', {
            resource: resource,
            _: 'No results found.',
        })))));
};
//# sourceMappingURL=ListNoResults.js.map