var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
var __rest = (this && this.__rest) || function (s, e) {
    var t = {};
    for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p) && e.indexOf(p) < 0)
        t[p] = s[p];
    if (s != null && typeof Object.getOwnPropertySymbols === "function")
        for (var i = 0, p = Object.getOwnPropertySymbols(s); i < p.length; i++) {
            if (e.indexOf(p[i]) < 0 && Object.prototype.propertyIsEnumerable.call(s, p[i]))
                t[p[i]] = s[p[i]];
        }
    return t;
};
import * as React from 'react';
import { useResourceContext, usePreference } from 'ra-core';
import { Configurable } from '../../preferences';
import { SimpleList } from './SimpleList';
import { SimpleListEditor } from './SimpleListEditor';
export var SimpleListConfigurable = function (_a) {
    var preferenceKey = _a.preferenceKey, props = __rest(_a, ["preferenceKey"]);
    var resource = useResourceContext(props);
    return (React.createElement(Configurable, { editor: React.createElement(SimpleListEditor, null), preferenceKey: preferenceKey || "".concat(resource, ".SimpleList"), sx: { display: 'block' } },
        React.createElement(SimpleListWithPreferences, __assign({}, props))));
};
var SimpleListWithPreferences = function (props) {
    var primaryTextFromStore = usePreference('primaryText')[0];
    var secondaryTextFromStore = usePreference('secondaryText')[0];
    var tertiaryTextFromStore = usePreference('tertiaryText')[0];
    return (React.createElement(SimpleList, __assign({}, props, { primaryText: primaryTextFromStore || props.primaryText, secondaryText: secondaryTextFromStore || props.secondaryText, tertiaryText: tertiaryTextFromStore || props.tertiaryText })));
};
//# sourceMappingURL=SimpleListConfigurable.js.map