var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
var __rest = (this && this.__rest) || function (s, e) {
    var t = {};
    for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p) && e.indexOf(p) < 0)
        t[p] = s[p];
    if (s != null && typeof Object.getOwnPropertySymbols === "function")
        for (var i = 0, p = Object.getOwnPropertySymbols(s); i < p.length; i++) {
            if (e.indexOf(p[i]) < 0 && Object.prototype.propertyIsEnumerable.call(s, p[i]))
                t[p[i]] = s[p[i]];
        }
    return t;
};
import * as React from 'react';
import { styled } from '@mui/material/styles';
import Avatar from '@mui/material/Avatar';
import { List, ListItem, ListItemAvatar, ListItemSecondaryAction, ListItemText, } from '@mui/material';
import { useTimeout } from 'ra-core';
import { Placeholder } from '../Placeholder';
export var SimpleListLoading = function (props) {
    var className = props.className, hasLeftAvatarOrIcon = props.hasLeftAvatarOrIcon, hasRightAvatarOrIcon = props.hasRightAvatarOrIcon, hasSecondaryText = props.hasSecondaryText, hasTertiaryText = props.hasTertiaryText, _a = props.nbFakeLines, nbFakeLines = _a === void 0 ? 5 : _a, rest = __rest(props, ["className", "hasLeftAvatarOrIcon", "hasRightAvatarOrIcon", "hasSecondaryText", "hasTertiaryText", "nbFakeLines"]);
    var oneSecondHasPassed = useTimeout(1000);
    return oneSecondHasPassed ? (React.createElement(StyledList, __assign({ className: className }, rest), times(nbFakeLines, function (key) { return (React.createElement(ListItem, { key: key },
        hasLeftAvatarOrIcon && (React.createElement(ListItemAvatar, null,
            React.createElement(Avatar, null, "\u00A0"))),
        React.createElement(ListItemText, { primary: React.createElement("div", null,
                React.createElement(Placeholder, { className: SimpleListLoadingClasses.primary }),
                hasTertiaryText && (React.createElement("span", { className: SimpleListLoadingClasses.tertiary },
                    React.createElement(Placeholder, null)))), secondary: hasSecondaryText ? React.createElement(Placeholder, null) : undefined }),
        hasRightAvatarOrIcon && (React.createElement(ListItemSecondaryAction, null,
            React.createElement(Avatar, null, "\u00A0"))))); }))) : null;
};
var PREFIX = 'RaSimpleListLoading';
export var SimpleListLoadingClasses = {
    primary: "".concat(PREFIX, "-primary"),
    tertiary: "".concat(PREFIX, "-tertiary"),
};
var StyledList = styled(List, {
    name: PREFIX,
    overridesResolver: function (props, styles) { return styles.root; },
})(function (_a) {
    var _b;
    var theme = _a.theme;
    return (_b = {},
        _b["& .".concat(SimpleListLoadingClasses.primary)] = {
            width: '30vw',
            display: 'inline-block',
            marginBottom: theme.spacing(),
        },
        _b["& .".concat(SimpleListLoadingClasses.tertiary)] = {
            float: 'right',
            opacity: 0.541176,
            minWidth: '10vw',
        },
        _b);
});
var times = function (nbChildren, fn) {
    return Array.from({ length: nbChildren }, function (_, key) { return fn(key); });
};
//# sourceMappingURL=SimpleListLoading.js.map