import * as React from 'react';
import { useState } from 'react';
import { useListContext, useTranslate } from 'ra-core';
import { Button, Dialog, DialogActions, DialogContent, DialogTitle, TextField, } from '@mui/material';
import { extractValidSavedQueries, useSavedQueries } from './useSavedQueries';
export var AddSavedQueryDialog = function (_a) {
    var open = _a.open, onClose = _a.onClose;
    var translate = useTranslate();
    var _b = useListContext(), resource = _b.resource, filterValues = _b.filterValues, displayedFilters = _b.displayedFilters, sort = _b.sort, perPage = _b.perPage;
    var _c = useSavedQueries(resource), savedQueries = _c[0], setSavedQueries = _c[1];
    // input state
    var _d = useState(''), queryName = _d[0], setQueryName = _d[1];
    var handleQueryNameChange = function (event) {
        setQueryName(event.target.value);
    };
    var handleFormSubmit = function (e) {
        e.preventDefault();
        addQuery();
    };
    var addQuery = function () {
        var newSavedQuery = {
            label: queryName,
            value: {
                filter: filterValues,
                sort: sort,
                perPage: perPage,
                displayedFilters: displayedFilters,
            },
        };
        var newSavedQueries = extractValidSavedQueries(savedQueries);
        setSavedQueries(newSavedQueries.concat(newSavedQuery));
        setQueryName('');
        onClose();
    };
    return (React.createElement(Dialog, { open: open, onClose: onClose, "aria-labelledby": "form-dialog-title" },
        React.createElement(DialogTitle, { id: "form-dialog-title" }, translate('ra.saved_queries.new_dialog_title', {
            _: 'Save current query as',
        })),
        React.createElement(DialogContent, null,
            React.createElement("form", { onSubmit: handleFormSubmit },
                React.createElement(TextField
                // eslint-disable-next-line jsx-a11y/no-autofocus
                , { 
                    // eslint-disable-next-line jsx-a11y/no-autofocus
                    autoFocus: true, margin: "dense", id: "name", label: translate('ra.saved_queries.query_name', {
                        _: 'Query name',
                    }), fullWidth: true, value: queryName, onChange: handleQueryNameChange }))),
        React.createElement(DialogActions, null,
            React.createElement(Button, { onClick: onClose }, translate('ra.action.cancel')),
            React.createElement(Button, { onClick: addQuery, color: "primary" }, translate('ra.action.save')))));
};
//# sourceMappingURL=AddSavedQueryDialog.js.map