var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
var __rest = (this && this.__rest) || function (s, e) {
    var t = {};
    for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p) && e.indexOf(p) < 0)
        t[p] = s[p];
    if (s != null && typeof Object.getOwnPropertySymbols === "function")
        for (var i = 0, p = Object.getOwnPropertySymbols(s); i < p.length; i++) {
            if (e.indexOf(p[i]) < 0 && Object.prototype.propertyIsEnumerable.call(s, p[i]))
                t[p[i]] = s[p[i]];
        }
    return t;
};
import * as React from 'react';
import { useState, useCallback, useRef, useContext, } from 'react';
import { Menu, MenuItem, ListItemIcon, ListItemText, styled, Divider, } from '@mui/material';
import ClearIcon from '@mui/icons-material/Clear';
import BookmarkAddIcon from '@mui/icons-material/BookmarkAdd';
import BookmarkRemoveIcon from '@mui/icons-material/BookmarkRemove';
import BookmarkBorderIcon from '@mui/icons-material/BookmarkBorder';
import ContentFilter from '@mui/icons-material/FilterList';
import isEqual from 'lodash/isEqual';
import { useListContext, useResourceContext, useTranslate } from 'ra-core';
import { stringify } from 'query-string';
import { useNavigate } from 'react-router';
import { FilterButtonMenuItem } from './FilterButtonMenuItem';
import { Button } from '../../button';
import { FilterContext } from '../FilterContext';
import { extractValidSavedQueries, useSavedQueries } from './useSavedQueries';
import { AddSavedQueryDialog } from './AddSavedQueryDialog';
import { RemoveSavedQueryDialog } from './RemoveSavedQueryDialog';
export var FilterButton = function (props) {
    var filtersProp = props.filters, className = props.className, disableSaveQuery = props.disableSaveQuery, size = props.size, variant = props.variant, rest = __rest(props, ["filters", "className", "disableSaveQuery", "size", "variant"]);
    var filters = useContext(FilterContext) || filtersProp;
    var resource = useResourceContext(props);
    var translate = useTranslate();
    if (!resource && !disableSaveQuery) {
        throw new Error('<FilterButton> must be called inside a ResourceContextProvider, or must provide a resource prop');
    }
    var savedQueries = useSavedQueries(resource || '')[0];
    var navigate = useNavigate();
    var _a = useListContext(), _b = _a.displayedFilters, displayedFilters = _b === void 0 ? {} : _b, filterValues = _a.filterValues, perPage = _a.perPage, setFilters = _a.setFilters, showFilter = _a.showFilter, hideFilter = _a.hideFilter, sort = _a.sort;
    var hasFilterValues = !isEqual(filterValues, {});
    var validSavedQueries = extractValidSavedQueries(savedQueries);
    var hasSavedCurrentQuery = validSavedQueries.some(function (savedQuery) {
        return isEqual(savedQuery.value, {
            filter: filterValues,
            sort: sort,
            perPage: perPage,
            displayedFilters: displayedFilters,
        });
    });
    var _c = useState(false), open = _c[0], setOpen = _c[1];
    var anchorEl = useRef();
    if (filters === undefined) {
        throw new Error('The <FilterButton> component requires the <List filters> prop to be set');
    }
    var allTogglableFilters = filters.filter(function (filterElement) { return !filterElement.props.alwaysOn; });
    var handleClickButton = useCallback(function (event) {
        // This prevents ghost click.
        event.preventDefault();
        setOpen(true);
        anchorEl.current = event.currentTarget;
    }, [anchorEl, setOpen]);
    var handleRequestClose = useCallback(function () {
        setOpen(false);
    }, [setOpen]);
    var handleShow = useCallback(function (_a) {
        var source = _a.source, defaultValue = _a.defaultValue;
        showFilter(source, defaultValue === '' ? undefined : defaultValue);
        // We have to fallback to imperative code because the new FilterFormInput
        // has no way of knowing it has just been displayed (and thus that it should focus its input)
        setTimeout(function () {
            var inputElement = document.querySelector("input[name='".concat(source, "']"));
            if (inputElement) {
                inputElement.focus();
            }
        }, 50);
        setOpen(false);
    }, [showFilter, setOpen]);
    var handleRemove = useCallback(function (_a) {
        var source = _a.source;
        hideFilter(source);
        setOpen(false);
    }, [hideFilter, setOpen]);
    // add query dialog state
    var _d = useState(false), addSavedQueryDialogOpen = _d[0], setAddSavedQueryDialogOpen = _d[1];
    var hideAddSavedQueryDialog = function () {
        setAddSavedQueryDialogOpen(false);
    };
    var showAddSavedQueryDialog = function () {
        setOpen(false);
        setAddSavedQueryDialogOpen(true);
    };
    // remove query dialog state
    var _e = useState(false), removeSavedQueryDialogOpen = _e[0], setRemoveSavedQueryDialogOpen = _e[1];
    var hideRemoveSavedQueryDialog = function () {
        setRemoveSavedQueryDialogOpen(false);
    };
    var showRemoveSavedQueryDialog = function () {
        setOpen(false);
        setRemoveSavedQueryDialogOpen(true);
    };
    if (allTogglableFilters.length === 0 &&
        validSavedQueries.length === 0 &&
        !hasFilterValues) {
        return null;
    }
    return (React.createElement(Root, __assign({ className: className }, sanitizeRestProps(rest)),
        React.createElement(Button, { className: "add-filter", label: "ra.action.add_filter", "aria-haspopup": "true", onClick: handleClickButton, variant: variant, size: size },
            React.createElement(ContentFilter, null)),
        React.createElement(Menu, { open: open, anchorEl: anchorEl.current, onClose: handleRequestClose },
            allTogglableFilters.map(function (filterElement, index) { return (React.createElement(FilterButtonMenuItem, { key: filterElement.props.source, filter: filterElement, displayed: !!displayedFilters[filterElement.props.source], resource: resource, onShow: handleShow, onHide: handleRemove, autoFocus: index === 0 })); }),
            (hasFilterValues || validSavedQueries.length > 0) && (React.createElement(Divider, null)),
            validSavedQueries.map(function (savedQuery, index) {
                return isEqual(savedQuery.value, {
                    filter: filterValues,
                    sort: sort,
                    perPage: perPage,
                    displayedFilters: displayedFilters,
                }) ? (React.createElement(MenuItem, { onClick: showRemoveSavedQueryDialog, key: index },
                    React.createElement(ListItemIcon, null,
                        React.createElement(BookmarkRemoveIcon, { fontSize: "small" })),
                    React.createElement(ListItemText, null, translate('ra.saved_queries.remove_label_with_name', {
                        _: 'Remove query "%{name}"',
                        name: savedQuery.label,
                    })))) : (React.createElement(MenuItem, { onClick: function () {
                        var _a, _b;
                        navigate({
                            search: stringify({
                                filter: JSON.stringify(savedQuery.value.filter),
                                sort: (_a = savedQuery.value.sort) === null || _a === void 0 ? void 0 : _a.field,
                                order: (_b = savedQuery.value.sort) === null || _b === void 0 ? void 0 : _b.order,
                                page: 1,
                                perPage: savedQuery.value.perPage,
                                displayedFilters: JSON.stringify(savedQuery.value.displayedFilters),
                            }),
                        });
                        setOpen(false);
                    }, key: index },
                    React.createElement(ListItemIcon, null,
                        React.createElement(BookmarkBorderIcon, { fontSize: "small" })),
                    React.createElement(ListItemText, null, savedQuery.label)));
            }),
            hasFilterValues &&
                !hasSavedCurrentQuery &&
                !disableSaveQuery && (React.createElement(MenuItem, { onClick: showAddSavedQueryDialog },
                React.createElement(ListItemIcon, null,
                    React.createElement(BookmarkAddIcon, { fontSize: "small" })),
                React.createElement(ListItemText, null, translate('ra.saved_queries.new_label', {
                    _: 'Save current query...',
                })))),
            hasFilterValues && (React.createElement(MenuItem, { onClick: function () {
                    setFilters({}, {});
                    setOpen(false);
                } },
                React.createElement(ListItemIcon, null,
                    React.createElement(ClearIcon, { fontSize: "small" })),
                React.createElement(ListItemText, null, translate('ra.action.remove_all_filters', {
                    _: 'Remove all filters',
                }))))),
        !disableSaveQuery && (React.createElement(React.Fragment, null,
            React.createElement(AddSavedQueryDialog, { open: addSavedQueryDialogOpen, onClose: hideAddSavedQueryDialog }),
            React.createElement(RemoveSavedQueryDialog, { open: removeSavedQueryDialogOpen, onClose: hideRemoveSavedQueryDialog })))));
};
/* eslint-disable @typescript-eslint/no-unused-vars */
var sanitizeRestProps = function (_a) {
    var _b = _a.displayedFilters, displayedFilters = _b === void 0 ? null : _b, _c = _a.filterValues, filterValues = _c === void 0 ? null : _c, _d = _a.showFilter, showFilter = _d === void 0 ? null : _d, rest = __rest(_a, ["displayedFilters", "filterValues", "showFilter"]);
    return rest;
};
var PREFIX = 'RaFilterButton';
var Root = styled('div', {
    name: PREFIX,
    overridesResolver: function (props, styles) { return styles.root; },
})({
    display: 'inline-block',
});
//# sourceMappingURL=FilterButton.js.map