var __spreadArray = (this && this.__spreadArray) || function (to, from, pack) {
    if (pack || arguments.length === 2) for (var i = 0, l = from.length, ar; i < l; i++) {
        if (ar || !(i in from)) {
            if (!ar) ar = Array.prototype.slice.call(from, 0, i);
            ar[i] = from[i];
        }
    }
    return to.concat(ar || Array.prototype.slice.call(from));
};
import * as React from 'react';
import isEqual from 'lodash/isEqual';
import { useListContext, useTranslate } from 'ra-core';
import { Button, Dialog, DialogActions, DialogContent, DialogContentText, DialogTitle, } from '@mui/material';
import { useSavedQueries, extractValidSavedQueries } from './useSavedQueries';
export var RemoveSavedQueryDialog = function (_a) {
    var open = _a.open, onClose = _a.onClose;
    var translate = useTranslate();
    var _b = useListContext(), resource = _b.resource, filterValues = _b.filterValues, sort = _b.sort, perPage = _b.perPage, displayedFilters = _b.displayedFilters;
    var _c = useSavedQueries(resource), savedQueries = _c[0], setSavedQueries = _c[1];
    var removeQuery = function () {
        var savedQueryToRemove = {
            filter: filterValues,
            sort: sort,
            perPage: perPage,
            displayedFilters: displayedFilters,
        };
        var newSavedQueries = extractValidSavedQueries(savedQueries);
        var index = newSavedQueries.findIndex(function (savedFilter) {
            return isEqual(savedFilter.value, savedQueryToRemove);
        });
        setSavedQueries(__spreadArray(__spreadArray([], newSavedQueries.slice(0, index), true), newSavedQueries.slice(index + 1), true));
        onClose();
    };
    return (React.createElement(Dialog, { open: open, onClose: onClose, "aria-labelledby": "alert-dialog-title", "aria-describedby": "alert-dialog-description" },
        React.createElement(DialogTitle, { id: "alert-dialog-title" }, translate('ra.saved_queries.remove_dialog_title', {
            _: 'Remove saved query?',
        })),
        React.createElement(DialogContent, null,
            React.createElement(DialogContentText, null, translate('ra.saved_queries.remove_message', {
                _: 'Are you sure you want to remove that item from your list of saved queries?',
            }))),
        React.createElement(DialogActions, null,
            React.createElement(Button, { onClick: onClose }, translate('ra.action.cancel')),
            React.createElement(Button, { onClick: removeQuery, color: "primary", 
                // eslint-disable-next-line jsx-a11y/no-autofocus
                autoFocus: true }, translate('ra.action.confirm')))));
};
//# sourceMappingURL=RemoveSavedQueryDialog.js.map