var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
import * as React from 'react';
import { useState } from 'react';
import { IconButton } from '@mui/material';
import RemoveIcon from '@mui/icons-material/RemoveCircleOutline';
import { useTranslate } from 'ra-core';
import { RemoveSavedQueryDialog } from './RemoveSavedQueryDialog';
export var RemoveSavedQueryIconButton = function (props) {
    var _a = useState(false), confirmationOpen = _a[0], setConfirmationOpen = _a[1];
    var handleConfirmationClose = function () {
        setConfirmationOpen(false);
    };
    var handleRemoveQueryClick = function () {
        setConfirmationOpen(true);
    };
    var translate = useTranslate();
    return (React.createElement(React.Fragment, null,
        React.createElement(IconButton, __assign({ "aria-label": translate('ra.saved_queries.remove_label', {
                _: 'Remove saved query',
            }), size: "small", onClick: handleRemoveQueryClick }, props),
            React.createElement(RemoveIcon, null)),
        React.createElement(RemoveSavedQueryDialog, { open: confirmationOpen, onClose: handleConfirmationClose })));
};
//# sourceMappingURL=RemoveSavedQueryIconButton.js.map