import * as React from 'react';
import { SxProps } from '@mui/material';
/**
 * A pagination component that loads more results when the user scrolls to the bottom of the list.
 *
 * Used as the default pagination component in the <InfiniteList> component.
 *
 * @example
 * import { InfiniteList, InfinitePagination, Datagrid, TextField } from 'react-admin';
 *
 * const PostList = () => (
 *    <InfiniteList pagination={<InfinitePagination sx={{ py: 5 }} />}>
 *       <Datagrid>
 *          <TextField source="id" />
 *         <TextField source="title" />
 *      </Datagrid>
 *   </InfiniteList>
 * );
 */
export declare const InfinitePagination: ({ options, sx, }: InfinitePaginationProps) => React.JSX.Element | null;
export interface InfinitePaginationProps {
    options?: IntersectionObserverInit;
    sx?: SxProps;
}
//# sourceMappingURL=InfinitePagination.d.ts.map