var __spreadArray = (this && this.__spreadArray) || function (to, from, pack) {
    if (pack || arguments.length === 2) for (var i = 0, l = from.length, ar; i < l; i++) {
        if (ar || !(i in from)) {
            if (!ar) ar = Array.prototype.slice.call(from, 0, i);
            ar[i] = from[i];
        }
    }
    return to.concat(ar || Array.prototype.slice.call(from));
};
import * as React from 'react';
import { usePreference, useTranslate } from 'ra-core';
import { Box, Button } from '@mui/material';
import { FieldToggle } from './FieldToggle';
/**
 * UI to select / deselect fields, and store the selection in preferences
 */
export var FieldsSelector = function (_a) {
    var _b = _a.name, name = _b === void 0 ? 'columns' : _b, _c = _a.availableName, availableName = _c === void 0 ? 'availableColumns' : _c;
    var translate = useTranslate();
    var _d = usePreference(availableName, []), availableFields = _d[0], setAvailableFields = _d[1];
    var omit = usePreference('omit', [])[0];
    var _e = usePreference(name, availableFields
        .filter(function (field) { return !(omit === null || omit === void 0 ? void 0 : omit.includes(field.source)); })
        .map(function (field) { return field.index; })), fields = _e[0], setFields = _e[1];
    var handleToggle = function (event) {
        if (event.target.checked) {
            // add the column at the right position
            setFields(availableFields
                .filter(function (field) {
                return field.index === event.target.name ||
                    fields.includes(field.index);
            })
                .map(function (field) { return field.index; }));
        }
        else {
            setFields(fields.filter(function (index) { return index !== event.target.name; }));
        }
    };
    var handleMove = function (index1, index2) {
        var index1Pos = availableFields.findIndex(
        // eslint-disable-next-line eqeqeq
        function (field) { return field.index == index1; });
        var index2Pos = availableFields.findIndex(
        // eslint-disable-next-line eqeqeq
        function (field) { return field.index == index2; });
        if (index1Pos === -1 || index2Pos === -1) {
            return;
        }
        var newAvailableFields;
        if (index1Pos > index2Pos) {
            newAvailableFields = __spreadArray(__spreadArray(__spreadArray(__spreadArray([], availableFields.slice(0, index2Pos), true), [
                availableFields[index1Pos]
            ], false), availableFields.slice(index2Pos, index1Pos), true), availableFields.slice(index1Pos + 1), true);
        }
        else {
            newAvailableFields = __spreadArray(__spreadArray(__spreadArray(__spreadArray([], availableFields.slice(0, index1Pos), true), availableFields.slice(index1Pos + 1, index2Pos + 1), true), [
                availableFields[index1Pos]
            ], false), availableFields.slice(index2Pos + 1), true);
        }
        setAvailableFields(newAvailableFields);
        setFields(function (fields) {
            return newAvailableFields
                .filter(function (field) { return fields.includes(field.index); })
                .map(function (field) { return field.index; });
        });
    };
    var handleHideAll = function () {
        setFields([]);
    };
    var handleShowAll = function () {
        setFields(availableFields.map(function (field) { return field.index; }));
    };
    return (React.createElement(Box, { pt: 0.5 },
        React.createElement(Box, { component: "ul", sx: { paddingInlineStart: 0, m: 0 } }, availableFields.map(function (field) { return (React.createElement(FieldToggle, { key: field.index, source: field.source, label: field.label, index: field.index, selected: fields.includes(field.index), onToggle: handleToggle, onMove: handleMove })); })),
        React.createElement(Box, { onDrop: function (e) { return e.preventDefault(); }, display: "flex", justifyContent: "space-between", mx: -0.5, mt: 1 },
            React.createElement(Button, { size: "small", onClick: handleHideAll }, translate('ra.inspector.hideAll', {
                _: 'Hide All',
            })),
            React.createElement(Button, { size: "small", onClick: handleShowAll }, translate('ra.inspector.showAll', {
                _: 'Show All',
            })))));
};
//# sourceMappingURL=FieldsSelector.js.map