import * as React from 'react';
import { useState, useEffect, useRef } from 'react';
import { useStore, usePreferencesEditor, useTranslate, useRemoveItemsFromStore, PreferenceKeyContextProvider, } from 'ra-core';
import { Paper, Typography, IconButton } from '@mui/material';
import CloseIcon from '@mui/icons-material/CancelOutlined';
import DeleteIcon from '@mui/icons-material/DeleteOutline';
import { useTheme, styled } from '@mui/material/styles';
import { InspectorRoot } from './InspectorRoot';
export var Inspector = function () {
    var _a = usePreferencesEditor(), isEnabled = _a.isEnabled, disable = _a.disable, title = _a.title, titleOptions = _a.titleOptions, editor = _a.editor, preferenceKey = _a.preferenceKey;
    var isDragging = useRef(false);
    var removeItems = useRemoveItemsFromStore(preferenceKey);
    var theme = useTheme();
    var translate = useTranslate();
    var _b = useState(0), version = _b[0], setVersion = _b[1];
    var _c = useStore('ra.inspector.position', {
        x: 
        // We want it positioned to the far right of the screen
        (document === null || document === void 0 ? void 0 : document.body.clientWidth) -
            // So we remove its size (see the root css class)
            theme.breakpoints.values.sm / 2 -
            // And add a margin
            8,
        y: 8,
    }), dialogPosition = _c[0], setDialogPosition = _c[1];
    // poor man's drag and drop
    // store click position relative to the dialog position
    var _d = useState(), clickPosition = _d[0], setClickPosition = _d[1];
    var handleDragStart = function (e) {
        // exit if the user drags on anything but the title
        var draggedElement = document === null || document === void 0 ? void 0 : document.elementFromPoint(e.clientX, e.clientY);
        if ((draggedElement === null || draggedElement === void 0 ? void 0 : draggedElement.id) !== 'inspector-dialog-title') {
            return;
        }
        isDragging.current = true;
        e.dataTransfer.effectAllowed = 'move';
        e.dataTransfer.setData('inspector', '');
        setTimeout(function () {
            e.target.classList.add('hide');
        }, 0);
        setClickPosition({
            x: e.clientX - dialogPosition.x,
            y: e.clientY - dialogPosition.y,
        });
    };
    var handleDragEnd = function (e) {
        if (isDragging.current && clickPosition) {
            setDialogPosition({
                x: e.clientX - clickPosition.x,
                y: e.clientY - clickPosition.y,
            });
            e.target.classList.remove('hide');
            isDragging.current = false;
        }
    };
    // prevent "back to base" animation when the inspector is dropped
    useEffect(function () {
        if (!isEnabled)
            return;
        var handleDragover = function (e) {
            if (e.dataTransfer.types.includes('inspector')) {
                e.preventDefault();
            }
        };
        document === null || document === void 0 ? void 0 : document.addEventListener('dragover', handleDragover);
        return function () {
            document === null || document === void 0 ? void 0 : document.removeEventListener('dragover', handleDragover);
        };
    }, [isEnabled]);
    // make sure that the dialog is always visible, as the stored position may be outside the screen
    useEffect(function () {
        if (!isEnabled)
            return;
        var moveInspectorIfOutsideScreen = function () {
            window === null || window === void 0 ? void 0 : window.requestAnimationFrame(function () {
                setDialogPosition(function (position) { return ({
                    x: Math.min(position.x, (document === null || document === void 0 ? void 0 : document.body.clientWidth) -
                        theme.breakpoints.values.sm / 2 -
                        8),
                    y: Math.min(position.y, (window === null || window === void 0 ? void 0 : window.innerHeight) - 50),
                }); });
            });
        };
        moveInspectorIfOutsideScreen();
        window === null || window === void 0 ? void 0 : window.addEventListener('resize', moveInspectorIfOutsideScreen);
        return function () {
            window === null || window === void 0 ? void 0 : window.removeEventListener('resize', moveInspectorIfOutsideScreen);
        };
    }, [isEnabled, setDialogPosition, theme.breakpoints.values.sm]);
    var handleReset = function () {
        removeItems();
        // force redraw of the form to use the default values
        setVersion(function (version) { return version + 1; });
    };
    if (!isEnabled)
        return null;
    return (React.createElement(StyledPaper, { className: InspectorClasses.modal, elevation: 3, draggable: true, onDragStart: handleDragStart, onDragEnd: handleDragEnd, sx: { left: dialogPosition.x, top: dialogPosition.y } },
        React.createElement("div", { className: InspectorClasses.title },
            React.createElement(Typography, { id: "inspector-dialog-title", variant: "overline", component: "div", py: 1, px: 2, flex: "1" }, title && translate(title, titleOptions)),
            React.createElement("span", { id: "inspector-toolbar" }),
            preferenceKey && (React.createElement(IconButton, { "aria-label": translate('ra.action.remove'), onClick: handleReset, size: "small" },
                React.createElement(DeleteIcon, { fontSize: "inherit" }))),
            React.createElement(IconButton, { "aria-label": translate('ra.action.close'), onClick: disable, size: "small", sx: { mr: 1 } },
                React.createElement(CloseIcon, { fontSize: "inherit" }))),
        React.createElement("div", { className: InspectorClasses.content, key: version },
            React.createElement(PreferenceKeyContextProvider, { value: preferenceKey }, editor || React.createElement(InspectorRoot, null)))));
};
var PREFIX = 'RaInspector';
export var InspectorClasses = {
    modal: "".concat(PREFIX, "-modal"),
    title: "".concat(PREFIX, "-title"),
    content: "".concat(PREFIX, "-content"),
};
var StyledPaper = styled(Paper, {
    name: PREFIX,
    overridesResolver: function (props, styles) { return styles.root; },
})(function (_a) {
    var _b;
    var theme = _a.theme;
    return (_b = {
            position: 'fixed',
            zIndex: theme.zIndex.modal + 1,
            width: theme.breakpoints.values.sm / 2,
            transition: theme.transitions.create(['height', 'width']),
            '&.hide': {
                display: 'none',
            }
        },
        _b["& .".concat(InspectorClasses.title)] = {
            display: 'flex',
            justifyContent: 'space-between',
            alignItems: 'center',
            cursor: 'move',
        },
        _b["& .".concat(InspectorClasses.content)] = {
            overflowY: 'auto',
            maxHeight: '75vh',
            padding: theme.spacing(2),
            paddingTop: 0,
        },
        _b);
});
Inspector.displayName = 'Inspector';
//# sourceMappingURL=Inspector.js.map