import * as React from 'react';
import { useMemo } from 'react';
import { ThemeProvider as MuiThemeProvider, createTheme, } from '@mui/material/styles';
import { useMediaQuery } from '@mui/material';
import { useTheme } from './useTheme';
import { useThemesContext } from './useThemesContext';
/**
 * This sets the Material UI theme based on the preferred theme type.
 *
 * @param props
 * @param props.children The children of the component.
 * @param {ThemeOptions} props.theme The initial theme. Optional, use the one from the context if not provided.
 *
 * @example
 *
 * import { ThemesContext, ThemeProvider } from 'react-admin';
 *
 * const App = () => (
 *    <ThemesContext.Provider value={{ lightTheme, darkTheme }}>
 *      <ThemeProvider>
 *        <Button>Test</Button>
 *      </ThemeProvider>
 *   </ThemesContext.Provider>
 * );
 */
export var ThemeProvider = function (_a) {
    var children = _a.children;
    var _b = useThemesContext(), lightTheme = _b.lightTheme, darkTheme = _b.darkTheme, defaultTheme = _b.defaultTheme;
    var prefersDarkMode = useMediaQuery('(prefers-color-scheme: dark)', {
        noSsr: true,
    });
    var mode = useTheme(defaultTheme || (prefersDarkMode && darkTheme ? 'dark' : 'light'))[0];
    var themeValue = useMemo(function () {
        try {
            return createTheme(mode === 'dark' ? darkTheme : lightTheme);
        }
        catch (e) {
            console.warn('Failed to reuse custom theme from store', e);
            return createTheme();
        }
    }, [mode, lightTheme, darkTheme]);
    return (React.createElement(MuiThemeProvider, { theme: themeValue }, children));
};
//# sourceMappingURL=ThemeProvider.js.map