var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
import { alpha, createTheme } from '@mui/material';
/**
 * Radiant: A theme emphasizing clarity and ease of use.
 *
 * Uses generous margins, outlined inputs and buttons, no uppercase, and an acid color palette.
 */
var componentsOverrides = function (theme) {
    var _a;
    var shadows = [
        alpha(theme.palette.primary.main, 0.2),
        alpha(theme.palette.primary.main, 0.1),
        alpha(theme.palette.primary.main, 0.05),
    ];
    return {
        MuiAppBar: {
            styleOverrides: {
                colorSecondary: {
                    backgroundColor: theme.palette.background.default,
                    color: theme.palette.text.primary,
                },
            },
        },
        MuiAutocomplete: {
            defaultProps: {
                fullWidth: true,
            },
        },
        MuiButton: {
            defaultProps: {
                variant: 'outlined',
            },
            styleOverrides: {
                sizeSmall: {
                    padding: "".concat(theme.spacing(0.5), " ").concat(theme.spacing(1.5)),
                },
            },
        },
        MuiFormControl: {
            defaultProps: {
                variant: 'outlined',
                margin: 'dense',
                size: 'small',
                fullWidth: true,
            },
        },
        MuiPaper: {
            styleOverrides: {
                elevation1: {
                    boxShadow: "".concat(shadows[0], " -2px 2px, ").concat(shadows[1], " -4px 4px,").concat(shadows[2], " -6px 6px"),
                },
                root: {
                    backgroundClip: 'padding-box',
                },
            },
        },
        MuiTableCell: {
            styleOverrides: {
                root: {
                    padding: theme.spacing(1.5),
                    '&.MuiTableCell-sizeSmall': {
                        padding: theme.spacing(1),
                    },
                    '&.MuiTableCell-paddingNone': {
                        padding: 0,
                    },
                },
            },
        },
        MuiTableRow: {
            styleOverrides: {
                root: {
                    '&:last-child td': { border: 0 },
                },
            },
        },
        MuiTextField: {
            defaultProps: {
                variant: 'outlined',
                margin: 'dense',
                size: 'small',
                fullWidth: true,
            },
        },
        RaDatagrid: {
            styleOverrides: {
                root: {
                    '& .RaDatagrid-headerCell': {
                        color: theme.palette.primary.main,
                    },
                },
            },
        },
        RaFilterForm: {
            styleOverrides: {
                root: (_a = {},
                    _a[theme.breakpoints.up('sm')] = {
                        minHeight: theme.spacing(6),
                    },
                    _a),
            },
        },
        RaLayout: {
            styleOverrides: {
                root: {
                    '& .RaLayout-appFrame': { marginTop: theme.spacing(5) },
                },
            },
        },
        RaMenuItemLink: {
            styleOverrides: {
                root: {
                    borderLeft: "3px solid ".concat(theme.palette.primary.contrastText),
                    '&:hover': {
                        borderRadius: '0px 100px 100px 0px',
                    },
                    '&.RaMenuItemLink-active': {
                        borderLeft: "3px solid ".concat(theme.palette.primary.main),
                        borderRadius: '0px 100px 100px 0px',
                        backgroundImage: "linear-gradient(98deg, ".concat(theme.palette.primary.light, ", ").concat(theme.palette.primary.dark, " 94%)"),
                        boxShadow: theme.shadows[1],
                        color: theme.palette.primary.contrastText,
                        '& .MuiSvgIcon-root': {
                            fill: theme.palette.primary.contrastText,
                        },
                    },
                },
            },
        },
        RaSimpleFormIterator: {
            defaultProps: {
                fullWidth: true,
            },
        },
        RaTranslatableInputs: {
            defaultProps: {
                fullWidth: true,
            },
        },
    };
};
var alert = {
    error: { main: '#DB488B' },
    warning: { main: '#F2E963' },
    info: { main: '#3ED0EB' },
    success: { main: '#0FBF9F' },
};
var darkPalette = __assign(__assign({ primary: { main: '#9055fd' }, secondary: { main: '#FF83F6' }, background: { default: '#110e1c', paper: '#151221' } }, alert), { mode: 'dark' });
var lightPalette = __assign(__assign({ primary: { main: '#9055fd' }, secondary: { main: '#A270FF' }, background: { default: '#f0f1f6' }, text: {
        primary: '#544f5a',
        secondary: '#89868D',
    } }, alert), { mode: 'light' });
var createRadiantTheme = function (palette) {
    var themeOptions = {
        palette: palette,
        shape: { borderRadius: 6 },
        sidebar: { width: 250 },
        spacing: 10,
        typography: {
            fontFamily: 'Gabarito, tahoma, sans-serif',
            h1: {
                fontWeight: 500,
                fontSize: '6rem',
            },
            h2: { fontWeight: 600 },
            h3: { fontWeight: 700 },
            h4: { fontWeight: 800 },
            h5: { fontWeight: 900 },
            button: { textTransform: undefined, fontWeight: 700 },
        },
    };
    var theme = createTheme(themeOptions);
    theme.components = componentsOverrides(theme);
    return theme;
};
export var radiantLightTheme = createRadiantTheme(lightPalette);
export var radiantDarkTheme = createRadiantTheme(darkPalette);
//# sourceMappingURL=radiantTheme.js.map