import { useStore } from 'ra-core';
import { useMediaQuery } from '@mui/material';
import { useThemesContext } from './useThemesContext';
/**
 * Read and update the theme mode (light or dark)
 *
 * @example
 * const [theme, setTheme] = useTheme('light');
 * const toggleTheme = () => {
 *    setTheme(theme === 'light' ? 'dark' : 'light');
 * };
 *
 */
export var useTheme = function (type) {
    var darkTheme = useThemesContext().darkTheme;
    var prefersDarkMode = useMediaQuery('(prefers-color-scheme: dark)', {
        noSsr: true,
    });
    var _a = useStore('theme', type !== null && type !== void 0 ? type : (prefersDarkMode && darkTheme ? 'dark' : 'light')), theme = _a[0], setter = _a[1];
    // Ensure that even though the store has its value set to 'dark', we still use the light theme when no dark theme is available
    return [darkTheme != null ? theme : 'light', setter];
};
//# sourceMappingURL=useTheme.js.map