# Comparison of CSS in JS Libraries for React

Library | Syntax | Mechanism | Override mechanism | Compile-time step | Media Queries | Pseudo styles | CSS Syntax | Animations | ES6 Classes | Vendor Prefixes | Dynamic styles | Isomorphic (runs on server)
-------- | -------- | -------- | -------- | -------- | -------- | -------- | -------- | -------- | -------- | -------- | -------- | --------
[Radium](https://github.com/FormidableLabs/radium) | Plain objects, `{ ':hover': {...}` + `style` attribute + HOC | [Pure inline styles](https://github.com/FormidableLabs/radium#how-does-radium-work) | Object.assign | No | [Yes](https://github.com/FormidableLabs/radium/tree/master/docs/guides#media-queries) | Yes - :hover, :active, :focus | [Yes](https://github.com/FormidableLabs/radium/tree/master/docs/faq#can-i-use-my-favourite-csslesssass-syntax) | [Yes](https://github.com/FormidableLabs/radium/tree/master/docs/api#keyframes) | [Yes](https://github.com/FormidableLabs/radium/tree/master/docs/guides#how-do-i-do-it-then) | Yes | Yes - anything can be done at runtime | Partial - media queries do not work yet
[React Style](https://github.com/js-next/react-style) | `StyleSheet.create(...)` + `style` attribute + monkey patching | Converts to CSS | CSS overrides hack - `.foo,.foo.foo1,.foo.foo1.foo2.` (etc.) | [Optional](https://github.com/js-next/react-style#extracting-styles-into-css-at-build-time) | [Yes](https://github.com/js-next/react-style#support-for-media-queries) | [No](https://github.com/js-next/react-style#not-supported-css-features) | [Yes](https://github.com/js-next/react-style#syntax-helpers-for-writing-styles) | No | Yes | Yes, if using [webpack extraction plugin](https://github.com/js-next/react-style#extracting-styles-into-css-at-build-time) | Yes - using inline styles | Yes, if using extraction
[React Inline](https://github.com/martinandert/react-inline) | `StyleSheet.create(...)` + `class` attribute | Converts to CSS | Unknown | Yes | Yes | Yes - all that are supported by CSS | No | No | Yes | Yes, after extraction | Yes - using inline styles | Yes
[jsxstyle](https://github.com/petehunt/jsxstyle) | JSX props, `<Block marginLeft={12} color={Theme.COLOR} />` | Converts to CSS | Unknown | Yes | Not yet | Not yet | No | No | Yes | Yes, after extraction | Yes - using inline styles | Yes
[React JSS](https://github.com/jsstyles/react-jss) | Plain objects + `className` attribute + HOC | Converts to CSS | [extend plugin](https://github.com/jsstyles/jss-extend) | Optional | Yes | Yes | No | Yes | Yes | [Yes](https://github.com/jsstyles/jss-vendor-prefixer) | Yes - using inline styles | Yes
[ReactShadow](https://github.com/Wildhoney/ReactShadow) | External CSS files | Shadow DOM for scoping | Same pitfalls as CSS | No | Yes | Yes | Yes | Yes | No | Yes, on external css | Yes - using inline styles | Yes
[native-css](https://github.com/raphamorim/native-css) | External CSS files | Generates `StyleSheet.create` declarations from CSS file for use with React Style | - | - | - | - | Yes | - | - | - | - | -
[react-in-style](https://github.com/ericwooley/react-in-style) | Plain objects, nested + `className` attribute + HOC | Converts to CSS | Same pitfalls as CSS | No | No | Yes | No | No | Yes | Yes, autoprefixer | Yes - using inline styles | Unknown
[react-css-builder](https://github.com/jhudson8/react-css-builder) | Plain objects + chained helpers `css.include(...).mixin(...).attr(...).css()` | Converts to CSS | Same pitfalls as CSS | No | No | No | No | No | Yes | Yes - [mixins](http://jhudson8.github.io/fancydocs/index.html#project/jhudson8/react-css-builder/section/Usage/Mixins?focus=outline) | Yes - using inline styles | Unknown
[React Free Style](https://github.com/blakeembrey/react-free-style) | `var TEXT_STYLE = Style.registerStyle({...});` + `className` attribute + HOC + `<Style.Element />` | Converts to CSS | Explicit - `FreeStyle#registerStyle(a, b, c)` | No | Yes | Yes | No | Yes | Yes | Unknown | Yes - explicit support `this.context.freeStyle.registerStyle(...)` | Yes
[React Inline CSS](https://github.com/RickWong/react-inline-css) | `<InlineCss stylesheet="...">{children}</InlineCss>` | Converts to CSS | Same pitfalls as CSS | No | Yes | Yes | Yes | Yes | Yes | Unknown | Yes - using inline styles | Unknown
[React Statics Styles](https://github.com/elierotenberg/react-statics-styles) | `statics: { styles: { ... } }` | Converts to CSS | Same pitfalls as CSS | Yes | Yes | Yes | No | Yes | Yes | Yes, after extraction | Yes - using inline styles | Yes
[react-styl](https://github.com/nick/react-styl) | `require('react-styl')('...css...')` + `require('react-style').addStylesheet();` | Converts to CSS | Same pitfalls as CSS | No | Yes | Yes | Yes | Yes | Yes | No | Yes - using inline styles | No
[smart-css](https://github.com/hackhat/smart-css) | `css.setClass('.b', { ... })` + `SmartCSS.injectStyles()` | Converts to CSS | Same pitfalls as CSS | No | Yes | Yes | No | No | Yes | Not yet | Yes - using inline styles | Not yet
[Stillr](https://github.com/chriskjaer/stilr) | `StyleSheet.create(...)` + `class` attribute | Converts to CSS | Same pitfalls as CSS | Optional | Yes | Yes | No | Yes | Yes | Yes, after extraction | Yes - using inline styles | Yes, if using extraction
