/* @flow */

'use strict';

exports.__esModule = true;

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { 'default': obj }; }

var _camelCasePropsToDashCase = require('../camel-case-props-to-dash-case');

var _camelCasePropsToDashCase2 = _interopRequireDefault(_camelCasePropsToDashCase);

var _createMarkupForStyles = require('../create-markup-for-styles');

var _createMarkupForStyles2 = _interopRequireDefault(_createMarkupForStyles);

var _prefixer = require('../prefixer');

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var buildCssString = function buildCssString(selector /*: string*/, rules /*: Object*/, userAgent /*: ?string*/) /*: string*/ {
  if (!selector || !rules) {
    return '';
  }

  var prefixedRules = _prefixer.getPrefixedStyle(rules, 'Style', userAgent);
  var cssPrefixedRules = _camelCasePropsToDashCase2['default'](prefixedRules);
  var serializedRules = _createMarkupForStyles2['default'](cssPrefixedRules);

  return selector + '{' + serializedRules + '}';
};

var Style = _react2['default'].createClass({
  displayName: 'Style',

  propTypes: {
    rules: _react2['default'].PropTypes.object,
    scopeSelector: _react2['default'].PropTypes.string
  },

  contextTypes: {
    radiumConfig: _react2['default'].PropTypes.object
  },

  getDefaultProps: function getDefaultProps() /*: {scopeSelector: string}*/ {
    return {
      prefix: _prefixer.getPrefixedStyle,
      scopeSelector: ''
    };
  },

  _buildStyles: function _buildStyles(styles /*: Object*/) /*: string*/ {
    var _this = this;

    return Object.keys(styles).reduce(function (accumulator, selector) {
      var rules = styles[selector];

      if (selector === 'mediaQueries') {
        accumulator += _this._buildMediaQueryString(rules);
      } else {
        var completeSelector = (_this.props.scopeSelector ? _this.props.scopeSelector + ' ' : '') + selector;
        accumulator += buildCssString(completeSelector, rules, _this.context && _this.context.radiumConfig && _this.context.radiumConfig.userAgent);
      }

      return accumulator;
    }, '');
  },

  _buildMediaQueryString: function _buildMediaQueryString(stylesByMediaQuery /*: {[mediaQuery: string]: Object}*/) /*: string*/ {
    var _this2 = this;

    var contextMediaQueries = this._getContextMediaQueries();
    var mediaQueryString = '';

    Object.keys(stylesByMediaQuery).forEach(function (query) {
      var completeQuery = contextMediaQueries[query] ? contextMediaQueries[query] : query;
      mediaQueryString += '@media ' + completeQuery + '{' + _this2._buildStyles(stylesByMediaQuery[query]) + '}';
    });

    return mediaQueryString;
  },

  _getContextMediaQueries: function _getContextMediaQueries() /*: {[mediaQuery: string]: Object}*/ {
    var _this3 = this;

    var contextMediaQueries = {};
    if (this.context && this.context.mediaQueries) {
      Object.keys(this.context.mediaQueries).forEach(function (query) {
        contextMediaQueries[query] = _this3.context.mediaQueries[query].media;
      });
    }

    return contextMediaQueries;
  },

  render: function render() /*: ?ReactElement*/ {
    if (!this.props.rules) {
      return null;
    }

    var styles = this._buildStyles(this.props.rules);

    return _react2['default'].createElement('style', { dangerouslySetInnerHTML: { __html: styles } });
  }
});

exports['default'] = Style;
module.exports = exports['default'];