'use strict';

exports.__esModule = true;

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { 'default': obj }; }

var _isPlainObject = require('is-plain-object');

var _isPlainObject2 = _interopRequireDefault(_isPlainObject);

var shouldMerge = function shouldMerge(value) {
  // Don't merge objects overriding toString, since they should be converted
  // to string values.
  return _isPlainObject2['default'](value) && value.toString === Object.prototype.toString;
};

// Merge style objects. Deep merge plain object values.
var mergeStyles = function mergeStyles(styles) {
  var result = {};

  styles.forEach(function (style) {
    if (!style || typeof style !== 'object') {
      return;
    }

    if (Array.isArray(style)) {
      style = mergeStyles(style);
    }

    Object.keys(style).forEach(function (key) {
      if (shouldMerge(style[key]) && shouldMerge(result[key])) {
        result[key] = mergeStyles([result[key], style[key]]);
      } else {
        result[key] = style[key];
      }
    });
  });

  return result;
};

exports['default'] = mergeStyles;
module.exports = exports['default'];