/**
 * Based on https://github.com/jsstyles/css-vendor, but without having to
 * convert between different cases all the time.
 *
 * @flow
 */

'use strict';

exports.__esModule = true;
exports.getPrefixedStyle = getPrefixedStyle;

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { 'default': obj }; }

var _inlineStylePrefixer = require('inline-style-prefixer');

var _inlineStylePrefixer2 = _interopRequireDefault(_inlineStylePrefixer);

function transformValues(style) {
  return Object.keys(style).reduce(function (newStyle, key) {
    var value = style[key];
    if (Array.isArray(value)) {
      value = value.join(';' + key + ':');
    }
    newStyle[key] = value;
    return newStyle;
  }, {});
}

var lastUserAgent = undefined;
var prefixer = undefined;

// Returns a new style object with vendor prefixes added to property names
// and values.

function getPrefixedStyle(style /*: Object*/, componentName /*: ?string*/, userAgent /*:: ?: ?string*/) /*: Object*/ {
  var actualUserAgent = userAgent || global && global.navigator && global.navigator.userAgent;

  if (!actualUserAgent) {
    throw new Error('Radium: userAgent must be supplied for server-side rendering. See ' + 'https://github.com/FormidableLabs/radium/tree/master/docs/api#radium ' + 'for more information.');
  }

  if (!prefixer || actualUserAgent !== lastUserAgent) {
    prefixer = new _inlineStylePrefixer2['default'](actualUserAgent);
    lastUserAgent = actualUserAgent;
  }

  var prefixedStyle = prefixer.prefix(style);
  var prefixedStyleWithFallbacks = transformValues(prefixedStyle);
  return prefixedStyleWithFallbacks;
}