'use strict';

const radixVue = require('radix-vue');

const Accordion = {
  Content: radixVue.AccordionContent,
  Header: radixVue.AccordionHeader,
  Item: radixVue.AccordionItem,
  Root: radixVue.AccordionRoot,
  Trigger: radixVue.AccordionTrigger
};
const AlertDialog = {
  Root: radixVue.AlertDialogRoot,
  Trigger: radixVue.AlertDialogTrigger,
  Portal: radixVue.AlertDialogPortal,
  Content: radixVue.AlertDialogContent,
  Overlay: radixVue.AlertDialogOverlay,
  Cancel: radixVue.AlertDialogCancel,
  Title: radixVue.AlertDialogTitle,
  Description: radixVue.AlertDialogDescription,
  Action: radixVue.AlertDialogAction
};
const Avatar = {
  Root: radixVue.AvatarRoot,
  Image: radixVue.AvatarImage,
  Fallback: radixVue.AvatarFallback
};
const Calendar = {
  Root: radixVue.CalendarRoot,
  Header: radixVue.CalendarHeader,
  Heading: radixVue.CalendarHeading,
  Grid: radixVue.CalendarGrid,
  Cell: radixVue.CalendarCell,
  HeadCell: radixVue.CalendarHeadCell,
  Next: radixVue.CalendarNext,
  Prev: radixVue.CalendarPrev,
  GridHead: radixVue.CalendarGridHead,
  GridBody: radixVue.CalendarGridBody,
  GridRow: radixVue.CalendarGridRow,
  CellTrigger: radixVue.CalendarCellTrigger
};
const Checkbox = {
  Root: radixVue.CheckboxRoot,
  Indicator: radixVue.CheckboxIndicator
};
const Collapsible = {
  Root: radixVue.CollapsibleRoot,
  Trigger: radixVue.CollapsibleTrigger,
  Content: radixVue.CollapsibleContent
};
const Combobox = {
  Root: radixVue.ComboboxRoot,
  Input: radixVue.ComboboxInput,
  Anchor: radixVue.ComboboxAnchor,
  Trigger: radixVue.ComboboxTrigger,
  Cancel: radixVue.ComboboxCancel,
  Group: radixVue.ComboboxGroup,
  Label: radixVue.ComboboxLabel,
  Content: radixVue.ComboboxContent,
  Empty: radixVue.ComboboxEmpty,
  Viewport: radixVue.ComboboxViewport,
  Item: radixVue.ComboboxItem,
  ItemIndicator: radixVue.ComboboxItemIndicator,
  Separator: radixVue.ComboboxSeparator,
  Arrow: radixVue.ComboboxArrow,
  Portal: radixVue.ComboboxPortal
};
const ContextMenu = {
  Root: radixVue.ContextMenuRoot,
  Trigger: radixVue.ContextMenuTrigger,
  Portal: radixVue.ContextMenuPortal,
  Content: radixVue.ContextMenuContent,
  Arrow: radixVue.ContextMenuArrow,
  Item: radixVue.ContextMenuItem,
  Group: radixVue.ContextMenuGroup,
  Separator: radixVue.ContextMenuSeparator,
  CheckboxItem: radixVue.ContextMenuCheckboxItem,
  ItemIndicator: radixVue.ContextMenuItemIndicator,
  Label: radixVue.ContextMenuLabel,
  RadioGroup: radixVue.ContextMenuRadioGroup,
  RadioItem: radixVue.ContextMenuRadioItem,
  Sub: radixVue.ContextMenuSub,
  SubContent: radixVue.ContextMenuSubContent,
  SubTrigger: radixVue.ContextMenuSubTrigger
};
const DateField = {
  Root: radixVue.DateFieldRoot,
  Input: radixVue.DateFieldInput
};
const DatePicker = {
  Header: radixVue.DatePickerHeader,
  Heading: radixVue.DatePickerHeading,
  Grid: radixVue.DatePickerGrid,
  Cell: radixVue.DatePickerCell,
  HeadCell: radixVue.DatePickerHeadCell,
  Next: radixVue.DatePickerNext,
  Prev: radixVue.DatePickerPrev,
  GridHead: radixVue.DatePickerGridHead,
  GridBody: radixVue.DatePickerGridBody,
  GridRow: radixVue.DatePickerGridRow,
  CellTrigger: radixVue.DatePickerCellTrigger,
  Input: radixVue.DatePickerInput,
  Root: radixVue.DatePickerRoot,
  Calendar: radixVue.DatePickerCalendar,
  Field: radixVue.DatePickerField,
  Anchor: radixVue.DatePickerAnchor,
  Arrow: radixVue.DatePickerArrow,
  Close: radixVue.DatePickerClose,
  Trigger: radixVue.DatePickerTrigger,
  Content: radixVue.DatePickerContent
};
const DateRangePicker = {
  Header: radixVue.DateRangePickerHeader,
  Heading: radixVue.DateRangePickerHeading,
  Grid: radixVue.DateRangePickerGrid,
  Cell: radixVue.DateRangePickerCell,
  HeadCell: radixVue.DateRangePickerHeadCell,
  Next: radixVue.DateRangePickerNext,
  Prev: radixVue.DateRangePickerPrev,
  GridHead: radixVue.DateRangePickerGridHead,
  GridBody: radixVue.DateRangePickerGridBody,
  GridRow: radixVue.DateRangePickerGridRow,
  CellTrigger: radixVue.DateRangePickerCellTrigger,
  Input: radixVue.DateRangePickerInput,
  Root: radixVue.DateRangePickerRoot,
  Calendar: radixVue.DateRangePickerCalendar,
  Field: radixVue.DateRangePickerField,
  Anchor: radixVue.DateRangePickerAnchor,
  Arrow: radixVue.DateRangePickerArrow,
  Close: radixVue.DateRangePickerClose,
  Trigger: radixVue.DateRangePickerTrigger,
  Content: radixVue.DateRangePickerContent
};
const DateRangeField = {
  Root: radixVue.DateRangeFieldRoot,
  Input: radixVue.DateRangeFieldInput
};
const Dialog = {
  Root: radixVue.DialogRoot,
  Trigger: radixVue.DialogTrigger,
  Portal: radixVue.DialogPortal,
  Content: radixVue.DialogContent,
  Overlay: radixVue.DialogOverlay,
  Close: radixVue.DialogClose,
  Title: radixVue.DialogTitle,
  Description: radixVue.DialogDescription
};
const DropdownMenu = {
  Root: radixVue.DropdownMenuRoot,
  Trigger: radixVue.DropdownMenuTrigger,
  Portal: radixVue.DropdownMenuPortal,
  Content: radixVue.DropdownMenuContent,
  Arrow: radixVue.DropdownMenuArrow,
  Item: radixVue.DropdownMenuItem,
  Group: radixVue.DropdownMenuGroup,
  Separator: radixVue.DropdownMenuSeparator,
  CheckboxItem: radixVue.DropdownMenuCheckboxItem,
  ItemIndicator: radixVue.DropdownMenuItemIndicator,
  Label: radixVue.DropdownMenuLabel,
  RadioGroup: radixVue.DropdownMenuRadioGroup,
  RadioItem: radixVue.DropdownMenuRadioItem,
  Sub: radixVue.DropdownMenuSub,
  SubContent: radixVue.DropdownMenuSubContent,
  SubTrigger: radixVue.DropdownMenuSubTrigger
};
const Editable = {
  Root: radixVue.EditableRoot,
  Area: radixVue.EditableArea,
  Input: radixVue.EditableInput,
  Preview: radixVue.EditablePreview,
  SubmitTrigger: radixVue.EditableSubmitTrigger,
  CancelTrigger: radixVue.EditableCancelTrigger,
  EditTrigger: radixVue.EditableEditTrigger
};
const HoverCard = {
  Root: radixVue.HoverCardRoot,
  Trigger: radixVue.HoverCardTrigger,
  Portal: radixVue.HoverCardPortal,
  Content: radixVue.HoverCardContent,
  Arrow: radixVue.HoverCardArrow
};
const Listbox = {
  Root: radixVue.ListboxRoot,
  Content: radixVue.ListboxContent,
  Filter: radixVue.ListboxFilter,
  Item: radixVue.ListboxItem,
  ItemIndicator: radixVue.ListboxItemIndicator,
  Virtualizer: radixVue.ListboxVirtualizer,
  Group: radixVue.ListboxGroup,
  GroupLabel: radixVue.ListboxGroupLabel
};
const Menubar = {
  Root: radixVue.MenubarRoot,
  Trigger: radixVue.MenubarTrigger,
  Portal: radixVue.MenubarPortal,
  Content: radixVue.MenubarContent,
  Arrow: radixVue.MenubarArrow,
  Item: radixVue.MenubarItem,
  Group: radixVue.MenubarGroup,
  Separator: radixVue.MenubarSeparator,
  CheckboxItem: radixVue.MenubarCheckboxItem,
  ItemIndicator: radixVue.MenubarItemIndicator,
  Label: radixVue.MenubarLabel,
  RadioGroup: radixVue.MenubarRadioGroup,
  RadioItem: radixVue.MenubarRadioItem,
  Sub: radixVue.MenubarSub,
  SubContent: radixVue.MenubarSubContent,
  SubTrigger: radixVue.MenubarSubTrigger,
  Menu: radixVue.MenubarMenu
};
const NavigationMenu = {
  Content: radixVue.NavigationMenuContent,
  Indicator: radixVue.NavigationMenuIndicator,
  Item: radixVue.NavigationMenuItem,
  Link: radixVue.NavigationMenuLink,
  List: radixVue.NavigationMenuList,
  Root: radixVue.NavigationMenuRoot,
  Sub: radixVue.NavigationMenuSub,
  Trigger: radixVue.NavigationMenuTrigger,
  Viewport: radixVue.NavigationMenuViewport
};
const NumberField = {
  Root: radixVue.NumberFieldRoot,
  Input: radixVue.NumberFieldInput,
  Increment: radixVue.NumberFieldIncrement,
  Decrement: radixVue.NumberFieldDecrement
};
const Pagination = {
  Root: radixVue.PaginationRoot,
  Ellipsis: radixVue.PaginationEllipsis,
  First: radixVue.PaginationFirst,
  Last: radixVue.PaginationLast,
  List: radixVue.PaginationList,
  ListItem: radixVue.PaginationListItem,
  Next: radixVue.PaginationNext,
  Prev: radixVue.PaginationPrev
};
const PinInput = {
  Root: radixVue.PinInputRoot,
  Input: radixVue.PinInputInput
};
const Popover = {
  Root: radixVue.PopoverRoot,
  Trigger: radixVue.PopoverTrigger,
  Portal: radixVue.PopoverPortal,
  Content: radixVue.PopoverContent,
  Arrow: radixVue.PopoverArrow,
  Close: radixVue.PopoverClose,
  Anchor: radixVue.PopoverAnchor
};
const Progress = {
  Root: radixVue.ProgressRoot,
  Indicator: radixVue.ProgressIndicator
};
const RadioGroup = {
  Root: radixVue.RadioGroupRoot,
  Item: radixVue.RadioGroupItem,
  Indicator: radixVue.RadioGroupIndicator
};
const RangeCalendar = {
  Root: radixVue.RangeCalendarRoot,
  Header: radixVue.RangeCalendarHeader,
  Heading: radixVue.RangeCalendarHeading,
  Grid: radixVue.RangeCalendarGrid,
  Cell: radixVue.RangeCalendarCell,
  HeadCell: radixVue.RangeCalendarHeadCell,
  Next: radixVue.RangeCalendarNext,
  Prev: radixVue.RangeCalendarPrev,
  GridHead: radixVue.RangeCalendarGridHead,
  GridBody: radixVue.RangeCalendarGridBody,
  GridRow: radixVue.RangeCalendarGridRow,
  CellTrigger: radixVue.RangeCalendarCellTrigger
};
const ScrollArea = {
  Root: radixVue.ScrollAreaRoot,
  Viewport: radixVue.ScrollAreaViewport,
  Scrollbar: radixVue.ScrollAreaScrollbar,
  Thumb: radixVue.ScrollAreaThumb,
  Corner: radixVue.ScrollAreaCorner
};
const Select = {
  Root: radixVue.SelectRoot,
  Trigger: radixVue.SelectTrigger,
  Portal: radixVue.SelectPortal,
  Content: radixVue.SelectContent,
  Arrow: radixVue.SelectArrow,
  Separator: radixVue.SelectSeparator,
  ItemIndicator: radixVue.SelectItemIndicator,
  Label: radixVue.SelectLabel,
  Group: radixVue.SelectGroup,
  Item: radixVue.SelectItem,
  ItemText: radixVue.SelectItemText,
  Viewport: radixVue.SelectViewport,
  ScrollUpButton: radixVue.SelectScrollUpButton,
  ScrollDownButton: radixVue.SelectScrollDownButton,
  Value: radixVue.SelectValue,
  Icon: radixVue.SelectIcon
};
const Slider = {
  Root: radixVue.SliderRoot,
  Thumb: radixVue.SliderThumb,
  Track: radixVue.SliderTrack,
  Range: radixVue.SliderRange
};
const Splitter = {
  Group: radixVue.SplitterGroup,
  Panel: radixVue.SplitterPanel,
  ResizeHandle: radixVue.SplitterResizeHandle
};
const Stepper = {
  Root: radixVue.StepperRoot,
  Item: radixVue.StepperItem,
  Trigger: radixVue.StepperTrigger,
  Description: radixVue.StepperDescription,
  Title: radixVue.StepperTitle,
  Indicator: radixVue.StepperIndicator,
  Separator: radixVue.StepperSeparator
};
const Switch = {
  Root: radixVue.SwitchRoot,
  Thumb: radixVue.SwitchThumb
};
const Tabs = {
  Root: radixVue.TabsRoot,
  List: radixVue.TabsList,
  Content: radixVue.TabsContent,
  Trigger: radixVue.TabsTrigger,
  Indicator: radixVue.TabsIndicator
};
const TagsInput = {
  Root: radixVue.TagsInputRoot,
  Input: radixVue.TagsInputInput,
  Item: radixVue.TagsInputItem,
  ItemText: radixVue.TagsInputItemText,
  ItemDelete: radixVue.TagsInputItemDelete,
  Clear: radixVue.TagsInputClear
};
const Toast = {
  Provider: radixVue.ToastProvider,
  Root: radixVue.ToastRoot,
  Action: radixVue.ToastAction,
  Close: radixVue.ToastClose,
  Viewport: radixVue.ToastViewport,
  Title: radixVue.ToastTitle,
  Description: radixVue.ToastDescription
};
const ToggleGroup = {
  Root: radixVue.ToggleGroupRoot,
  Item: radixVue.ToggleGroupItem
};
const Toolbar = {
  Root: radixVue.ToolbarRoot,
  Button: radixVue.ToolbarButton,
  Link: radixVue.ToolbarLink,
  ToggleGroup: radixVue.ToolbarToggleGroup,
  ToggleItem: radixVue.ToolbarToggleItem,
  Separator: radixVue.ToolbarSeparator
};
const Tooltip = {
  Root: radixVue.TooltipRoot,
  Trigger: radixVue.TooltipTrigger,
  Content: radixVue.TooltipContent,
  Arrow: radixVue.TooltipArrow,
  Portal: radixVue.TooltipPortal,
  Provider: radixVue.TooltipProvider
};
const Tree = {
  Root: radixVue.TreeRoot,
  Item: radixVue.TreeItem,
  Virtualizer: radixVue.TreeVirtualizer
};

exports.AspectRatio = radixVue.AspectRatio;
exports.Label = radixVue.Label;
exports.Separator = radixVue.Separator;
exports.Toggle = radixVue.Toggle;
exports.Viewport = radixVue.Viewport;
exports.Accordion = Accordion;
exports.AlertDialog = AlertDialog;
exports.Avatar = Avatar;
exports.Calendar = Calendar;
exports.Checkbox = Checkbox;
exports.Collapsible = Collapsible;
exports.Combobox = Combobox;
exports.ContextMenu = ContextMenu;
exports.DateField = DateField;
exports.DatePicker = DatePicker;
exports.DateRangeField = DateRangeField;
exports.DateRangePicker = DateRangePicker;
exports.Dialog = Dialog;
exports.DropdownMenu = DropdownMenu;
exports.Editable = Editable;
exports.HoverCard = HoverCard;
exports.Listbox = Listbox;
exports.Menubar = Menubar;
exports.NavigationMenu = NavigationMenu;
exports.NumberField = NumberField;
exports.Pagination = Pagination;
exports.PinInput = PinInput;
exports.Popover = Popover;
exports.Progress = Progress;
exports.RadioGroup = RadioGroup;
exports.RangeCalendar = RangeCalendar;
exports.ScrollArea = ScrollArea;
exports.Select = Select;
exports.Slider = Slider;
exports.Splitter = Splitter;
exports.Stepper = Stepper;
exports.Switch = Switch;
exports.Tabs = Tabs;
exports.TagsInput = TagsInput;
exports.Toast = Toast;
exports.ToggleGroup = ToggleGroup;
exports.Toolbar = Toolbar;
exports.Tooltip = Tooltip;
exports.Tree = Tree;
