'use strict';

const kit = require('@nuxt/kit');

const components = {
  accordion: [
    "AccordionContent",
    "AccordionHeader",
    "AccordionItem",
    "AccordionRoot",
    "AccordionTrigger"
  ],
  alertDialog: [
    "AlertDialogRoot",
    "AlertDialogTrigger",
    "AlertDialogPortal",
    "AlertDialogContent",
    "AlertDialogOverlay",
    "AlertDialogCancel",
    "AlertDialogTitle",
    "AlertDialogDescription",
    "AlertDialogAction"
  ],
  aspectRatio: [
    "AspectRatio"
  ],
  avatar: [
    "AvatarRoot",
    "AvatarImage",
    "AvatarFallback"
  ],
  calendar: [
    "CalendarRoot",
    "CalendarHeader",
    "CalendarHeading",
    "CalendarGrid",
    "CalendarCell",
    "CalendarHeadCell",
    "CalendarNext",
    "CalendarPrev",
    "CalendarGridHead",
    "CalendarGridBody",
    "CalendarGridRow",
    "CalendarCellTrigger"
  ],
  checkbox: [
    "CheckboxRoot",
    "CheckboxIndicator"
  ],
  collapsible: [
    "CollapsibleRoot",
    "CollapsibleTrigger",
    "CollapsibleContent"
  ],
  combobox: [
    "ComboboxRoot",
    "ComboboxInput",
    "ComboboxAnchor",
    "ComboboxTrigger",
    "ComboboxCancel",
    "ComboboxGroup",
    "ComboboxLabel",
    "ComboboxContent",
    "ComboboxEmpty",
    "ComboboxViewport",
    "ComboboxItem",
    "ComboboxItemIndicator",
    "ComboboxSeparator",
    "ComboboxArrow",
    "ComboboxPortal"
  ],
  configProvider: [
    "ConfigProvider"
  ],
  contextMenu: [
    "ContextMenuRoot",
    "ContextMenuTrigger",
    "ContextMenuPortal",
    "ContextMenuContent",
    "ContextMenuArrow",
    "ContextMenuItem",
    "ContextMenuGroup",
    "ContextMenuSeparator",
    "ContextMenuCheckboxItem",
    "ContextMenuItemIndicator",
    "ContextMenuLabel",
    "ContextMenuRadioGroup",
    "ContextMenuRadioItem",
    "ContextMenuSub",
    "ContextMenuSubContent",
    "ContextMenuSubTrigger"
  ],
  dateField: [
    "DateFieldRoot",
    "DateFieldInput"
  ],
  datePicker: [
    "DatePickerHeader",
    "DatePickerHeading",
    "DatePickerGrid",
    "DatePickerCell",
    "DatePickerHeadCell",
    "DatePickerNext",
    "DatePickerPrev",
    "DatePickerGridHead",
    "DatePickerGridBody",
    "DatePickerGridRow",
    "DatePickerCellTrigger",
    "DatePickerInput",
    "DatePickerRoot",
    "DatePickerCalendar",
    "DatePickerField",
    "DatePickerAnchor",
    "DatePickerArrow",
    "DatePickerClose",
    "DatePickerTrigger",
    "DatePickerContent"
  ],
  dateRangePicker: [
    "DateRangePickerHeader",
    "DateRangePickerHeading",
    "DateRangePickerGrid",
    "DateRangePickerCell",
    "DateRangePickerHeadCell",
    "DateRangePickerNext",
    "DateRangePickerPrev",
    "DateRangePickerGridHead",
    "DateRangePickerGridBody",
    "DateRangePickerGridRow",
    "DateRangePickerCellTrigger",
    "DateRangePickerInput",
    "DateRangePickerRoot",
    "DateRangePickerCalendar",
    "DateRangePickerField",
    "DateRangePickerAnchor",
    "DateRangePickerArrow",
    "DateRangePickerClose",
    "DateRangePickerTrigger",
    "DateRangePickerContent"
  ],
  dateRangeField: [
    "DateRangeFieldRoot",
    "DateRangeFieldInput"
  ],
  dialog: [
    "DialogRoot",
    "DialogTrigger",
    "DialogPortal",
    "DialogContent",
    "DialogOverlay",
    "DialogClose",
    "DialogTitle",
    "DialogDescription"
  ],
  dropdownMenu: [
    "DropdownMenuRoot",
    "DropdownMenuTrigger",
    "DropdownMenuPortal",
    "DropdownMenuContent",
    "DropdownMenuArrow",
    "DropdownMenuItem",
    "DropdownMenuGroup",
    "DropdownMenuSeparator",
    "DropdownMenuCheckboxItem",
    "DropdownMenuItemIndicator",
    "DropdownMenuLabel",
    "DropdownMenuRadioGroup",
    "DropdownMenuRadioItem",
    "DropdownMenuSub",
    "DropdownMenuSubContent",
    "DropdownMenuSubTrigger"
  ],
  editable: [
    "EditableRoot",
    "EditableArea",
    "EditableInput",
    "EditablePreview",
    "EditableSubmitTrigger",
    "EditableCancelTrigger",
    "EditableEditTrigger"
  ],
  focusScope: [
    "FocusScope"
  ],
  hoverCard: [
    "HoverCardRoot",
    "HoverCardTrigger",
    "HoverCardPortal",
    "HoverCardContent",
    "HoverCardArrow"
  ],
  label: [
    "Label"
  ],
  listbox: [
    "ListboxRoot",
    "ListboxContent",
    "ListboxFilter",
    "ListboxItem",
    "ListboxItemIndicator",
    "ListboxVirtualizer",
    "ListboxGroup",
    "ListboxGroupLabel"
  ],
  menubar: [
    "MenubarRoot",
    "MenubarTrigger",
    "MenubarPortal",
    "MenubarContent",
    "MenubarArrow",
    "MenubarItem",
    "MenubarGroup",
    "MenubarSeparator",
    "MenubarCheckboxItem",
    "MenubarItemIndicator",
    "MenubarLabel",
    "MenubarRadioGroup",
    "MenubarRadioItem",
    "MenubarSub",
    "MenubarSubContent",
    "MenubarSubTrigger",
    "MenubarMenu"
  ],
  navigationMenu: [
    "NavigationMenuContent",
    "NavigationMenuIndicator",
    "NavigationMenuItem",
    "NavigationMenuLink",
    "NavigationMenuList",
    "NavigationMenuRoot",
    "NavigationMenuSub",
    "NavigationMenuTrigger",
    "NavigationMenuViewport"
  ],
  numberField: [
    "NumberFieldRoot",
    "NumberFieldInput",
    "NumberFieldIncrement",
    "NumberFieldDecrement"
  ],
  pagination: [
    "PaginationRoot",
    "PaginationEllipsis",
    "PaginationFirst",
    "PaginationLast",
    "PaginationList",
    "PaginationListItem",
    "PaginationNext",
    "PaginationPrev"
  ],
  pinInput: [
    "PinInputRoot",
    "PinInputInput"
  ],
  popover: [
    "PopoverRoot",
    "PopoverTrigger",
    "PopoverPortal",
    "PopoverContent",
    "PopoverArrow",
    "PopoverClose",
    "PopoverAnchor"
  ],
  progress: [
    "ProgressRoot",
    "ProgressIndicator"
  ],
  radioGroup: [
    "RadioGroupRoot",
    "RadioGroupItem",
    "RadioGroupIndicator"
  ],
  rangeCalendar: [
    "RangeCalendarRoot",
    "RangeCalendarHeader",
    "RangeCalendarHeading",
    "RangeCalendarGrid",
    "RangeCalendarCell",
    "RangeCalendarHeadCell",
    "RangeCalendarNext",
    "RangeCalendarPrev",
    "RangeCalendarGridHead",
    "RangeCalendarGridBody",
    "RangeCalendarGridRow",
    "RangeCalendarCellTrigger"
  ],
  scrollArea: [
    "ScrollAreaRoot",
    "ScrollAreaViewport",
    "ScrollAreaScrollbar",
    "ScrollAreaThumb",
    "ScrollAreaCorner"
  ],
  select: [
    "SelectRoot",
    "SelectTrigger",
    "SelectPortal",
    "SelectContent",
    "SelectArrow",
    "SelectSeparator",
    "SelectItemIndicator",
    "SelectLabel",
    "SelectGroup",
    "SelectItem",
    "SelectItemText",
    "SelectViewport",
    "SelectScrollUpButton",
    "SelectScrollDownButton",
    "SelectValue",
    "SelectIcon"
  ],
  separator: [
    "Separator"
  ],
  slider: [
    "SliderRoot",
    "SliderThumb",
    "SliderTrack",
    "SliderRange"
  ],
  splitter: [
    "SplitterGroup",
    "SplitterPanel",
    "SplitterResizeHandle"
  ],
  stepper: [
    "StepperRoot",
    "StepperItem",
    "StepperTrigger",
    "StepperDescription",
    "StepperTitle",
    "StepperIndicator",
    "StepperSeparator"
  ],
  switch: [
    "SwitchRoot",
    "SwitchThumb"
  ],
  tabs: [
    "TabsRoot",
    "TabsList",
    "TabsContent",
    "TabsTrigger",
    "TabsIndicator"
  ],
  tagsInput: [
    "TagsInputRoot",
    "TagsInputInput",
    "TagsInputItem",
    "TagsInputItemText",
    "TagsInputItemDelete",
    "TagsInputClear"
  ],
  toast: [
    "ToastProvider",
    "ToastRoot",
    "ToastPortal",
    "ToastAction",
    "ToastClose",
    "ToastViewport",
    "ToastTitle",
    "ToastDescription"
  ],
  toggle: [
    "Toggle"
  ],
  toggleGroup: [
    "ToggleGroupRoot",
    "ToggleGroupItem"
  ],
  toolbar: [
    "ToolbarRoot",
    "ToolbarButton",
    "ToolbarLink",
    "ToolbarToggleGroup",
    "ToolbarToggleItem",
    "ToolbarSeparator"
  ],
  tooltip: [
    "TooltipRoot",
    "TooltipTrigger",
    "TooltipContent",
    "TooltipArrow",
    "TooltipPortal",
    "TooltipProvider"
  ],
  tree: [
    "TreeRoot",
    "TreeItem",
    "TreeVirtualizer"
  ],
  viewport: [
    "Viewport"
  ],
  primitive: [
    "Primitive",
    "Slot"
  ],
  visuallyHidden: [
    "VisuallyHidden"
  ]
};

const index = kit.defineNuxtModule({
  meta: {
    name: "@radix-vue/nuxt",
    configKey: "radix",
    compatibility: {
      nuxt: ">=3.0.0"
    }
  },
  defaults: {
    prefix: "",
    components: true
  },
  setup(options) {
    function getComponents() {
      if (typeof options.components === "object") {
        return Object.entries(components).filter(([name]) => options.components[name]).flatMap(([_, components]) => components);
      }
      if (options.components)
        return Object.values(components).flat();
      return [];
    }
    for (const component of getComponents()) {
      kit.addComponent({
        name: `${options.prefix}${component}`,
        export: component,
        filePath: "radix-vue"
      });
    }
  }
});

module.exports = index;
