/**
 * The function `areEqual` compares two arrays and returns true if they are equal in length and have
 * the same elements at corresponding indexes.
 * @param {any[]} arrayA - An array of any type of elements.
 * @param {any[]} arrayB - It looks like you haven't provided the value for `arrayB`. Could you please
 * provide the arrayB value so that I can assist you further?
 * @returns The function `areEqual` is returning a boolean value, either `true` if the two input arrays
 * `arrayA` and `arrayB` are equal, or `false` if they are not equal.
 */
export declare function areEqual(arrayA: any[], arrayB: any[]): boolean;
/**
 * Splits an array into chunks of a given size.
 * @param arr The array to split.
 * @param size The size of each chunk.
 * @returns An array of arrays, where each sub-array has `size` elements from the original array.
 * @example ```ts
 * const arr = [1, 2, 3, 4, 5, 6, 7, 8];
 * const chunks = chunk(arr, 3);
 * // chunks = [[1, 2, 3], [4, 5, 6], [7, 8]]
 * ```
 */
export declare function chunk<T>(arr: T[], size: number): T[][];
/**
 * The function `findValuesBetween` takes an array and two values, then returns a subarray containing
 * elements between the first occurrence of the start value and the first occurrence of the end value
 * in the array.
 * @param {T[]} array - The `array` parameter is an array of values of type `T`.
 * @param {T} start - The `start` parameter is the value that marks the beginning of the range you want
 * to find in the array.
 * @param {T} end - The `end` parameter in the `findValuesBetween` function represents the end value
 * that you want to find in the array. This function will return a subarray of values that are between
 * the `start` and `end` values in the original array.
 * @returns The `findValuesBetween` function returns an array of values from the input array that are
 * between the `start` and `end` values (inclusive). If either the `start` or `end` values are not
 * found in the input array, an empty array is returned.
 */
export declare function findValuesBetween<T>(array: T[], start: T, end: T): T[];
