import { MaybeRefOrGetter } from 'vue';
/**
 * The `useForwardProps` function in TypeScript takes in a set of props and returns a computed value
 * that combines default props with assigned props from the current instance.
 * @param {T} props - The `props` parameter is an object that represents the props passed to a
 * component.
 * @returns computed value that combines the default props, preserved props, and assigned props.
 */
export declare function useForwardProps<T extends Record<string, any>>(props: MaybeRefOrGetter<T>): import('vue').ComputedRef<T>;
