import { Ref } from 'vue';
export declare function useTypeahead(collections?: Ref<HTMLElement[]>): {
    search: Ref<string>;
    handleTypeaheadSearch: (key: string, fallback?: HTMLElement[]) => HTMLElement | undefined;
    resetTypeahead: () => void;
};
/**
 * Wraps an array around itself at a given start index
 * Example: `wrapArray(['a', 'b', 'c', 'd'], 2) === ['c', 'd', 'a', 'b']`
 */
export declare function wrapArray<T>(array: T[], startIndex: number): T[];
/**
 * This is the "meat" of the typeahead matching logic. It takes in all the values,
 * the search and the current match, and returns the next match (or `undefined`).
 *
 * We normalize the search because if a user has repeatedly pressed a character,
 * we want the exact same behavior as if we only had that one character
 * (ie. cycle through options starting with that character)
 *
 * We also reorder the values by wrapping the array around the current match.
 * This is so we always look forward from the current match, and picking the first
 * match will always be the correct one.
 *
 * Finally, if the normalized search is exactly one character, we exclude the
 * current match from the values because otherwise it would be the first to match always
 * and focus would never move. This is as opposed to the regular case, where we
 * don't want focus to move if the current match still matches.
 */
export declare function getNextMatch(values: string[], search: string, currentMatch?: string): string | undefined;
