const fs = require('fs-extra')
const path = require('path')
const R = require('rambda')

const generateRambdaExports = async () => {
  try{
    const separator = '// Follows code generated by `run rambda`'
    const filePath = path.resolve(__dirname,'../rambdax.js')
    const rambdaxContent = R.compose(
      R.join(''),
      R.append(separator),
      R.take(1),
      R.split(separator)
    )(fs.readFileSync(filePath).toString())

    const content = R.compose(
      R.join('\n'),
      R.prepend(rambdaxContent),
      R.map(x => `export const ${x} = R.${x}`)
    )(Object.keys(R))

    fs.writeFileSync(filePath, content)

    return 'done'
  }catch(err){
    console.log(err)
    throw err
  }
}

generateRambdaExports()
.then(console.log)
.catch(console.log)
